
export default class LoopBg extends egret.DisplayObjectContainer {
    resArr = []
    displayArr = []
    dir: Direction = Direction.vertical

    constructor(resArr: string[], dir: Direction = Direction.vertical) {
        super()
        this.resArr = resArr
        this.dir = dir
        switch (dir) {
            case Direction.horizontal:
                break;
            case Direction.vertical:
                this.resArr.forEach((res, idx) => {
                    let img = new egret.Bitmap(RES.getRes(res));
                    img.height = 1636
                    img.x = 0;
                    img.y = 0 - idx * 1624
                    this.addChild(img)
                    this.displayArr.push(img)
                })


                break
        }

        // this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this)
    }

    speed: number = 0;

    isPause: boolean = false
    onEnterFrame() {
        if (!this.isPause) {
            if (this.displayArr.length >= 2) {

                let bg = this.displayArr[0]
                let bg2 = this.displayArr[1]
                if (bg.y >= 1624) {
                    // this.displayArr.shift()
                    bg.y = bg2.y - 1624
                } else {
                    bg.y += this.speed;
                }

                if (bg2.y >= 1624) {
                    bg2.y = bg.y - 1624
                } else {
                    bg2.y += this.speed;
                }

                // console.log("bg:", bg.y);

                // console.log("bg2:", bg2.y);

            }
        }
    }

}

export enum Direction {
    horizontal,
    vertical
}