import GameConst, { arr, wait } from './../consts/GameConst';
import { DataManager } from './../../libs/tw/manager/DataManager';
import { GDispatcher } from './../../libs/tc/util/GDispatcher';
import { TwFun } from './../../libs/tw/util/TwFun';

import { ModuleTypes } from './../types/ModuleTypes';
import { NetPromise } from './../promises/NetPromise';
import Scene from "../views/Scene";
import SVGACtrl from "../ctrls/svgaCtrl";
import ToastCtrl from '../ctrls/toastCtrl';
import PanelCtrl from '../ctrls/panelCtrl';
import Waiting from '../waiting/Waiting';
import SceneCtrl from '../ctrls/sceneCtrl';

export default class StartScene extends Scene {
    public get skinKey() { return "Start" }

    public main: eui.Group;
    public bg: eui.Image;
    public sled: eui.Group;
    public hand: eui.Group;
    public recordBtn: eui.Button;
    public ruleBtn: eui.Button;
    public costTxt: eui.Label;
    public creditsTxt: eui.Label;
    public title: eui.Group;
    public star0: eui.Image;
    public star1: eui.Image;
    public star2: eui.Image;
    public star3: eui.Image;
    public startBtn: eui.Group;
    public musicOn: eui.Image;
    public musicOff: eui.Image;



    public get lastCredits() { return DataManager.ins.getData("gameAjaxElement").data.element.myCreditsLong }
    public get unitName() { return DataManager.ins.customCfgData.unitName }

    start() {
        super.start()
        this.initUI()

    }

    initUI() {
        if (GameConst.isPlayMusic) {
            this.musicOn.visible = true;
            this.musicOff.visible = false;
        } else {
            this.musicOn.visible = false;
            this.musicOff.visible = true;
        }


        this.updateIndex()
        this.initAni()
    }


    initEvents() {
        super.initEvents()
        this.onTap(this.recordBtn, this.onTap_recordBtn)
        this.onTap(this.ruleBtn, this.onTap_ruleBtn)
        this.onTap(this.startBtn, this.onTap_startBtn)

        this.onTap(this.musicOn, this.onTap_musicOn);
        this.onTap(this.musicOff, this.onTap_musicOff);

        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this)


        GDispatcher.addEvent("updateIndex", this.updateIndex, this)
    }

    onTap_musicOn(e) {
        e.stopPropagation();
        GameConst.isPlayMusic = false;
        this.musicOn.visible = !this.musicOn.visible;
        this.musicOff.visible = !this.musicOff.visible;
        window['playBg0Music'](false);
    }

    onTap_musicOff(e) {
        e.stopPropagation();
        GameConst.isPlayMusic = true;
        this.musicOn.visible = !this.musicOn.visible;
        this.musicOff.visible = !this.musicOff.visible;

        window['playBg0Music'](true);
    }

    onEnterFrame() {
        this.musicOn.rotation += 1;
    }

    updateIndex() {
        let startBtn = new window['SVGA'].EgretMovieClip(SVGACtrl.instance.getSVGAByName("startBtn"));
        this.startBtn.addChild(startBtn)


        if (DataManager.ins.customCfgData["uid"] == 'not_login') {
            // 未登录
            this.costTxt.text = `未登录`
            return
        }
        if (DataManager.ins.getData('gameAjaxElement').data && DataManager.ins.getData('gameAjaxElement').data.element) {
            if (DataManager.ins.getData('gameAjaxElement').data.element.status == 3) {
                this.costTxt.text = `游戏次数已用完`;
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 4) {
                this.costTxt.text = `今日次数已用完`;
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 5 && DataManager.ins.getData('gameAjaxElement').data.element.freeLimit > 0) {
                this.costTxt.text = `今日剩余免费次数:${DataManager.ins.getData('gameAjaxElement').data.element.freeLimit}次`
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 7 && DataManager.ins.getData('gameAjaxElement').data.element.freeLimit > 0) {
                this.costTxt.text = `剩余免费次数:${DataManager.ins.getData('gameAjaxElement').data.element.freeLimit}次`
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 2 || DataManager.ins.getData('gameAjaxElement').data.element.needCreditsLong > DataManager.ins.getData('gameAjaxElement').data.element.myCreditsLong) {
                this.costTxt.text = `${DataManager.ins.customCfgData.unitName || '积分'}不足`;
            } else {
                this.costTxt.text = `${DataManager.ins.getData('gameAjaxElement').data.element.needCredits}${DataManager.ins.customCfgData.unitName || '积分'}/次`
            }
        }


        this.creditsTxt.text = `剩余${this.unitName}:${this.lastCredits}`
    }

    onTap_startBtn() {
        // 判断是否进行游戏
        if (DataManager.ins.customCfgData["uid"] == 'not_login') {
            // 未登录
            PanelCtrl.instance.show(ModuleTypes.LOGIN_PANEL);
            return
        }
        if (DataManager.ins.getData('gameAjaxElement').data && DataManager.ins.getData('gameAjaxElement').data.element) {
            if (DataManager.ins.getData('gameAjaxElement').data.element.status == 3) {
                ToastCtrl.instance.show(`游戏次数已用完`);
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 4) {
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, { msg: "抱歉，今日次数已用完，\n明日再来吧~", title: "次数不足", type: "tips" })
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 5 && DataManager.ins.getData('gameAjaxElement').data.element.freeLimit > 0) {
                this.doStart();
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 2 || DataManager.ins.getData('gameAjaxElement').data.element.needCreditsLong > DataManager.ins.getData('gameAjaxElement').data.element.myCreditsLong) {
                PanelCtrl.instance.show(ModuleTypes.GETCREDITS_PANEL);
            } else {
                PanelCtrl.instance.show(ModuleTypes.WARNING_PANEL);
            }
        }

    }

    doStart() {


        Waiting.instance.show()
        NetPromise.doJoin()
            .then(() => {
                return NetPromise.getStartStatus()
            })
            .then(() => {
                Waiting.instance.hide()
                SceneCtrl.instance.change(ModuleTypes.PLAY_SCENE)
            })
            .catch((e) => {
                console.error(e);
                Waiting.instance.hide()
                ToastCtrl.instance.show("网络异常，请稍后再试~")
            })
    }

    onTap_recordBtn() {
        window.location.href = TwFun.getRecordUrl("00");
    }

    onTap_ruleBtn() {
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL)
    }

    removeEvents() {
        super.removeEvents
        this.clearTap(this.recordBtn, this.onTap_recordBtn)
        this.clearTap(this.ruleBtn, this.onTap_ruleBtn)
        this.clearTap(this.startBtn, this.onTap_startBtn)
        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this)

        GDispatcher.removeEvent("updateIndex", this.updateIndex)
    }




    async initAni() {
        this.snowAni()

        await wait(330)
        this.titleAni()
            .then(() => {
                this.starAni()
            })

        this.sledAni()
            .then(() => {
                this.handAni()
            })

    }

    titleAni() {
        return new Promise(r => {
            egret.Tween.get(this.title)
                .to({ scaleX: 1 }, 660)
                .call(() => {
                    r()
                })
        })
    }

    starAni() {
        egret.Tween.get(this.star0, { loop: true })
            .to({ rotation: -5 }, 330)
            .to({ rotation: 5 }, 660)
            .to({ rotation: 0 }, 330)
            .to({ rotation: -5 }, 330)
            .to({ rotation: 5 }, 660)
            .to({ rotation: 0 }, 330)


        wait(330)
            .then(() => {
                egret.Tween.get(this.star1, { loop: true })
                    .to({ rotation: -5 }, 330)
                    .to({ rotation: 5 }, 660)
                    .to({ rotation: 0 }, 330)
                    .to({ rotation: -5 }, 330)
                    .to({ rotation: 5 }, 660)
                    .to({ rotation: 0 }, 330)

            })

        wait(660)
            .then(() => {
                egret.Tween.get(this.star2, { loop: true })
                    .to({ rotation: -5 }, 330)
                    .to({ rotation: 5 }, 660)
                    .to({ rotation: 0 }, 330)
                    .to({ rotation: -5 }, 330)
                    .to({ rotation: 5 }, 660)
                    .to({ rotation: 0 }, 330)

            })

        egret.Tween.get(this.star3, { loop: true })
            .to({ rotation: -5 }, 330)
            .to({ rotation: 5 }, 660)
            .to({ rotation: 0 }, 330)
            .to({ rotation: -5 }, 330)
            .to({ rotation: 5 }, 660)
            .to({ rotation: 0 }, 330)

    }

    sledAni() {
        return new Promise((r) => {
            this.sled.x = 800 //65
            this.sled.y = -500 //60
            this.sled.visible = true
            egret.Tween.get(this.sled)
                .to({ x: 65, y: 60 }, 660)
                .call(() => {
                    r()
                })
        })
    }

    handAni() {
        egret.Tween.get(this.hand)
            .to({ rotation: 0 }, 330)
    }

    snowAni() {
        for (let i = 0; i < 100; i++) {
            let snow = new eui.Image()
            snow.source = `smallSnow_png`
            snow.x = Math.random() * 750
            snow.y = Math.random() * -1000
            let scale = Math.random() * 1.5
            snow.scaleX = scale;
            snow.scaleY = scale;
            let idx = arr.getRandomOne([101, 101, 1])
            this.main.addChildAt(snow, idx)
            egret.Tween.get(snow, { loop: true })
                .to({ y: 1800 }, Math.max(Math.random() * 15000, Math.max(Math.random() * 6000, 4000)))
        }
    }
}