import { DataManager } from './../../libs/tw/manager/DataManager';
import NetConst from './../consts/NetConst';
export class NetPromise {


    // 获取活动基础信息
    static ajaxElement() {
        return new Promise((r, j) => {
            NetConst.ajaxElement((s) => {
                if (!s) {
                    j(s)
                }
                r()
            });
        })
    }

    /**
     * 参与游戏
     */
    static doJoin() {
        return new Promise((r, j) => {
            NetConst.doJoin((s) => {
                if (!s) {
                    j(s)
                }
                r()
            });
        })
    }

    static getStartStatus() {
        return new Promise((r, j) => {
            NetConst.getNgameStartStatus((s) => {
                if (!s) {
                    j(s)
                }
                r()
            },
                DataManager.ins.getData("doJoin").data,
                () => {
                    return DataManager.ins.getData("getNgameStartStatus").code == "C000000001"
                });
        })
    }

    static submit(orderId, score, submitToken) {
        return new Promise((r, j) => {
            NetConst.ngameSubmit((s) => {
                if (!s) {
                    j(s)
                }
                r()
            }, orderId, score, '[]', '[]', submitToken);
        })
    }

    static getOrderStatus() {
        return new Promise((r, j) => {
            NetConst.getOrderStatus((s) => {
                if (!s) {
                    j(s)
                }
                r()
            },
                DataManager.ins.getData("doJoin").data,
                () => {
                    return DataManager.ins.getData("getOrderStatus").code == "C000000001"
                });
        })
    }

}