import { DataManager } from './../../../libs/tw/manager/DataManager';
import { ModuleTypes } from './../../types/ModuleTypes';
import { NetPromise } from './../../promises/NetPromise';
import Panel from "../../views/Panel";
import Waiting from "../../waiting/Waiting";
import SceneCtrl from '../../ctrls/sceneCtrl';
import ToastCtrl from '../../ctrls/toastCtrl';

export default class warningPanel extends Panel {
    get skinKey() {
        return "Warning"
    }

    public bg: eui.Image;
    public closeBtn: eui.Button;
    public sureBtn: eui.Button;
    public warningTips: eui.Label;
    public title: eui.Image;

    get unitName() { return window['CFG'].unitName }
    get cost() { return DataManager.ins.getData("gameAjaxElement").data.element.needCreditsLong }

    constructor() {
        super()

        this.warningTips.text = `确认消耗${this.cost}${this.unitName}参与游戏吗？`
    }

    initEvents() {
        super.initEvents()
        this.onTap(this.sureBtn, this.doStart)
    }

    removeEvents() {
        super.removeEvents()
        this.clearTap(this.sureBtn, this.doStart)
    }

    doStart() {
        Waiting.instance.show()
        NetPromise.doJoin()
            .then(() => {
                return NetPromise.getStartStatus()
            })
            .then(() => {
                Waiting.instance.hide()
                this.hidePanel()
                SceneCtrl.instance.change(ModuleTypes.PLAY_SCENE)
            })
            .catch((e) => {
                console.error(e);
                Waiting.instance.hide()
                ToastCtrl.instance.show("网络异常，请稍后再试~")
            })
    }

}