import { NetPromise } from './../../promises/NetPromise';
import { NetManager } from '../../../libs/tw/manager/NetManager';
import { DataManager } from '../../../libs/tw/manager/DataManager';
import { HtmlTextParser } from "./HtmlTextParser";
import Panel from "../../views/Panel";
import ToastCtrl from '../../ctrls/toastCtrl';

export default class RulePanel extends Panel {
    public closeBtn0: eui.Button;
    public scroller: eui.Scroller;
    public group: eui.Group;
    public labContent: eui.Label;
    public closeBtn: eui.Button;

    start() {
        if (window['ruleTxt']) {
            this.labContent.textFlow = (new HtmlTextParser).parser(window['ruleTxt']);
        } else {
            if (!DataManager.ins.getData("gameAjaxElement")) {
                NetPromise.ajaxElement()
                    .then(() => {
                        this.addRule();
                    })
                    .catch((e) => {
                        console.error(e);
                        ToastCtrl.instance.show("获取规则失败，请稍后重试~")
                    })
            }
            else {
                this.addRule();
            }
        }
    }

    private addRule() {
        const text = DataManager.ins.getData("gameAjaxElement").data.rule;
        this.labContent.textFlow = (new HtmlTextParser).parser(text);
    }

    initEvents() {
        super.initEvents()
        this.onTap(this.closeBtn0, this.onTouchTap)
    }

    removeEvents() {
        super.removeEvents()
        this.clearTap(this.closeBtn0, this.onTouchTap)
    }

    get skinKey() { return 'Rule' }
}