import { BarrierType } from './../../scenes/playScene/Barrier';
import { NetPromise } from '../../promises/NetPromise';
import Panel from "../../views/Panel";
import SceneCtrl from "../../ctrls/sceneCtrl";
import { ModuleTypes } from "../../types/ModuleTypes";
import PanelCtrl from '../../ctrls/panelCtrl';

export default class GameFailPanel extends Panel {
    get skinKey() {
        return "GameFail"
    }

    public bg: eui.Image;
    public closeBtn: eui.Button;
    public againBtn: eui.Button;
    public msgTitle: eui.Label;
    public msgTxt: eui.Label;


    constructor(data) {
        super()

        switch (data.type) {
            case BarrierType.SNOWBALL:
                this.msgTxt.text = `哎呀，一不小心被砸晕了~`;
                break;
            case BarrierType.HOLE:
                this.msgTxt.text = `哎呀，圣诞老人消失了～`;
                break;
            case BarrierType.STONE:
                this.msgTxt.text = `哎呀，一不小心被砸晕了~`;
                break;

        }
    }

    initEvents() {
        super.initEvents()
        this.onTap(this.againBtn, this.onTap_againBtn)
        this.onTap(this.closeBtn, this.onTap_againBtn)
    }

    onTap_againBtn() {
        NetPromise.ajaxElement()
            .then(() => {
                this.hidePanel()
                SceneCtrl.instance.change(ModuleTypes.START_SCENE)
            })
            .catch(e => {
                console.error(e);
                this.hidePanel()
                SceneCtrl.instance.change(ModuleTypes.START_SCENE)
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, { msg: "网络异常，请稍后重试~", type: "reload" })
            })
    }

    removeEvents() {
        super.removeEvents()

        this.clearTap(this.againBtn, this.onTap_againBtn)
        this.clearTap(this.closeBtn, this.onTap_againBtn)
    }
}