import { GDispatcher } from './../../../libs/tc/util/GDispatcher';
import { NetPromise } from './../../promises/NetPromise';
import { DataManager } from './../../../libs/tw/manager/DataManager';
import { LotteryType } from './../../../libs/tw/enum/LotteryType';
import { NetManager } from './../../../libs/tw/manager/NetManager';
import { Buried } from './../../../libs/tw/util/Buried';
import Panel from "../../views/Panel";
import SceneCtrl from '../../ctrls/sceneCtrl';
import { ModuleTypes } from '../../types/ModuleTypes';
import ToastCtrl from '../../ctrls/toastCtrl';
import getOptionImgSize from './data/getOptionImgSize';
import ImgSizeType from './data/ImgSizeType';

export default class PrizePanel extends Panel {

    protected get skinKey() { return 'Prize' }

    public prizeName: eui.Label;
    public sureBtn: eui.Button;
    public prizeImg: eui.Image;
    public closeBtn: eui.Button;
    public scoreTxt: eui.Label;
    public maxScoreTxt: eui.Label;



    get lottery() { return DataManager.ins.getData("getOrderStatus").data.lottery; }
    get score() { return DataManager.ins.getData("ngameSubmit").data.score }
    get maxScore() { return DataManager.ins.getData("ngameSubmit").data.maxScore }
    get picWidth() { return 250 };
    get picBigWidth() { return 500 };
    get bigPicRatio() { return 640 / 300 }

    //埋点

    // 开始
    start() {
        if (this.lottery) {
            const sizeType = getOptionImgSize(this.lottery);
            if (ImgSizeType.BIG === sizeType) {

                this.prizeImg.width = this.picBigWidth;
                this.prizeImg.height = this.picBigWidth / this.bigPicRatio;
            } else {
                this.prizeImg.width = this.prizeImg.height = this.picWidth;
            }
            this.prizeName.text = this.lottery.title;
            this.prizeImg.source = this.lottery.imgUrl;
            this.prizeImg.y = 645;
            this.prizeImg.anchorOffsetX = 250 / 2;
            this.prizeImg.anchorOffsetY = 250 / 2;
        }

        if (this.score) {
            this.scoreTxt.text = `${this.score}`
        } else {
            this.scoreTxt.text = `0`
        }

        if (this.score) {
            this.maxScoreTxt.text = `${this.maxScore}`
        } else {
            this.maxScoreTxt.text = `0`
        }
    }



    initEvents() {
        super.initEvents();
        this.onTap(this.closeBtn, this.onTap_CloseBtn)
        this.onTap(this.sureBtn, this.onTap_GetPrize)
        this.onTap(this.prizeImg, this.onTap_GetPrize)
    }

    onTap_GetPrize() {
        if (this.lottery.type == LotteryType.LUCKY) {

            window["downloadAppConfig"] =
                {
                    openUrl: this.lottery.openUrl,
                    iosDownloadUrl: this.lottery.iosDownloadUrl,
                    androidDownloadUrl: this.lottery.androidDownloadUrl,
                    confirm: this.lottery.confirm ? this.lottery.confirm : false
                };
            window["downloadApp"]();
            if (this.lottery.type == "lucky") {
                NetManager.ins.spmclick(DataManager.ins.getData("getOrderStatus").exposure);
            }
        } else {
            window.location.href = DataManager.ins.getData("getOrderStatus").data.lottery.link;
        }

    }

    onTap_CloseBtn(e: egret.TouchEvent) {
        NetPromise.ajaxElement()
            .then(() => {
                this.hidePanel()
                SceneCtrl.instance.change(ModuleTypes.START_SCENE)
            })
            .catch(e => {
                console.error(e);
                this.hidePanel()
                SceneCtrl.instance.change(ModuleTypes.START_SCENE)
                ToastCtrl.instance.show("网络错误，请稍后重试~")
            })
    }


    removeEvents() {
        super.removeEvents()
        this.clearTap(this.closeBtn, this.onTap_CloseBtn)
        this.clearTap(this.sureBtn, this.onTap_CloseBtn)
        this.clearTap(this.prizeImg, this.onTap_GetPrize)
    }

}