import { noPrizeTypes } from './../../scenes/playScene/PlayScene';
import { DataManager } from './../../../libs/tw/manager/DataManager';
import { NetManager } from './../../../libs/tw/manager/NetManager';
import { ModuleTypes } from './../../types/ModuleTypes';
import Panel from "../../views/Panel";
import SceneCtrl from "../../ctrls/sceneCtrl";
import PanelCtrl from '../../ctrls/panelCtrl';
import { NetPromise } from '../../promises/NetPromise';
import ToastCtrl from '../../ctrls/toastCtrl';
import Waiting from '../../waiting/Waiting';
export default class NoPrizePanel extends Panel {
    protected get skinKey() { return 'NoPrize' }

    public bg: eui.Image;
    public img: eui.Image;
    public failTxt: eui.Label;
    public sureBtn: eui.Button;
    public againBtn: eui.Button;
    public closeBtn: eui.Button;
    public noPrizeTitle: eui.Image;
    public failTitle: eui.Image;
    public emoji: eui.Image;

    start(data) {

        switch (data.type) {
            case noPrizeTypes.FAIL:
                this.noPrizeTitle.visible = false
                this.failTitle.visible = true
                this.failTxt.text = `哎呀，就差那么一丢丢了`
                break;
            case noPrizeTypes.NOPRIZE:
                this.noPrizeTitle.visible = true
                this.failTitle.visible = false
                this.failTxt.text = `感恩大礼与你失之交臂`
                break;
            case noPrizeTypes.THANKS:
                this.noPrizeTitle.visible = true
                this.failTitle.visible = false
                this.failTxt.text = `感恩大礼与你失之交臂`
                break;
            default:
                break;
        }

    }

    initEvents() {
        super.initEvents();

        this.onTap(this.againBtn, this.onTap_CloseBtn)
        this.onTap(this.closeBtn, this.onTap_CloseBtn)
        this.onTap(this.sureBtn, this.onTap_CloseBtn)
    }

    private onTap_CloseBtn(e: egret.TouchEvent) {
        Waiting.instance.show()
        NetPromise.ajaxElement()
            .then(() => {
                this.hidePanel();
                Waiting.instance.hide()
                SceneCtrl.instance.change(ModuleTypes.START_SCENE)
            })
            .catch((e) => {
                console.error(e);
                Waiting.instance.hide()
                ToastCtrl.instance.show("网络异常，请稍后再试~")
            })
    }

}