import Panel from "../../views/Panel";

export class LoginPanel extends Panel {
    get skinKey() {
        return "Login"
    }

    public bg: eui.Image;
    public loginBtn: eui.Button;
    public msgTitle: eui.Label;
    public msgTxt: eui.Label;


    initEvents() {
        super.initEvents();
        this.onTap(this.loginBtn, this.onTap_loginBtn);
    }

    onTap_loginBtn() {
        // 赚积分链接
        if (window['requirelogin']) {
            window['requirelogin']()
        } else {
            this.hidePanel();
        }
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.loginBtn, this.onTap_loginBtn);
    }

}