import { DataManager } from './../../../libs/tw/manager/DataManager';
import Panel from "../../views/Panel";


export default class GetCreditsPanel extends Panel {

    get skinKey() { return "GetCredits" }

    public closeBtn: eui.Button;
    public bg: eui.Image;
    public earnBtn: eui.Button;
    public msgTitle: eui.Label;
    public tips: eui.Label;


    start() {
        this.msgTitle.text = `${DataManager.ins.customCfgData.unitName}不足`;
        this.tips.text = `抱歉，您当前的${DataManager.ins.customCfgData.unitName}不足`;
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.earnBtn, this.onTap_earnBtn);
        this.onTap(this.closeBtn, this.onTouchTap);
    }

    onTap_earnBtn() {
        // 赚积分链接
        if (window["CFG"] && window["CFG"].getCreditsLink && window["CFG"].getCreditsLink !== "") {
            window.location.href = window["CFG"].getCreditsLink;
        } else {
            this.hidePanel();
        }
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.earnBtn, this.onTap_earnBtn);
        this.clearTap(this.closeBtn, this.onTouchTap);
    }

}