import { getSkinPath } from "../utils";

export default class ComponentBase extends eui.Component {
    protected data: any;
    constructor(data?) {
        super();
        this.data = data ? data : {};
        this.skinName = getSkinPath(this.skinKey);
        if (this.skin) {
            this.onSkinComplete();
        } else {
            this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        }
    }

    protected initEvents() { }

    protected removeEvents() { }

    start(data?) {

    }

    // 添加点击
    protected onTap(target, func) {
        target.addEventListener(egret.TouchEvent.TOUCH_TAP, func, this);
    }

    // 移除点击事件
    protected clearTap(target, func) {
        target.removeEventListener(egret.TouchEvent.TOUCH_TAP, func, this);
    }

    protected enableTap(b) {
        this.touchChildren = b;
        this.touchEnabled = b;
    }


    protected get skinKey() { return null }

    protected onSkinComplete() {
        this.initEvents();
    }

    destroy() {
        this.removeEvents();
    }

}