import { IData } from "../../../tc/interface/IData";

// import { IData } from "../../../../tc/interface/IData";
// 
// import { IData } from "../../../../tc/interface/IData";

/**
 * 签到信息查询
 */
export class SignInfoVo implements IData {
    /**
     * 历史累积签到次数
     */
    public acmDay = 0;

    /**
     * 抽期内累计签到天数
     */
    public acmDays = 0;

    /**
     * 今日奖励抽奖次数
     */
    public activityCount = 0;

    /**
     * 明天签到奖励抽奖次数
     */
    public activityCountTomorrow = 0;

    /**
     * 连续签到天数
     */
    public continueDay = 0;

    /**
     * 今日签到奖励积分
     */
    public credits = 0;

    /**
     * 明日签到奖励抽奖次数
     */
    public creditsTomorrow = 0;

    /**
     * 首次签到日期
     */
    public firstSignDate = 0;

    /**
     * 是否有累计奖励
     */
    public hasAcmReward = false;

    /**
     * 连续签到天数
     */
    public lastDays = 0;

    /**
     * 连续签到天数      
     */
    public monthResignedMap: any;

    /**
     * 周期内已签到日期记录
     */
    public monthSignedMap: any;

    /**
     * 今天是否已签到
     */
    public todaySigned = false;

    /**
     * 奖励集合
     */
    public rewardMap: any;

    public update(result: any): void {
        if (!result) {
            return;
        }
        this.acmDay = result.acmDay;
        this.acmDays = result.acmDays;
        this.activityCount = result.activityCount;
        this.activityCountTomorrow = result.activityCountTomorrow;
        this.continueDay = result.continueDay;
        this.credits = result.credits;
        this.creditsTomorrow = result.creditsTomorrow;
        this.firstSignDate = result.firstSignDate;
        this.hasAcmReward = result.hasAcmReward;
        this.lastDays = result.lastDays;
        this.monthResignedMap = result.monthResignedMap;
        this.monthSignedMap = result.monthSignedMap;
        this.todaySigned = result.todaySigned;
        if (result.rewardMap) {
            this.rewardMap = result.rewardMap;
        }
    }
}