import { LayoutType } from "../enum/LayoutType";

export abstract class ABStageManager {
    /**
     * 添加显示对象到指定容器
     * @param {any} child 对象实例
     * @param {any} container 容器实例
     * @param {number} 指定层级 默认不指定层级
     */
    public abstract addChild(child: any, container: any, index: number): void

    /**
     * 移除显示对象从父容器
     * @param child 要移除的显示对象
     */
    public abstract removeChild(child): void

    /**
     * 对齐方式
     * @param display 显示对象
     * @param mode 对齐方式 （left, right, top, bottom, horizontal, vertical）
     * @param offset 偏移量
     */
    public abstract align(display: any, layout: LayoutType, offset: number): void
}