import StartScene from "./StartScene";
import Monkey from "./Monkey";

export default class GuideCtrl {
    private _main: StartScene;
    private _tag: boolean;
    private _guideTop: egret.Sprite;
    constructor(view: StartScene) {
        this._main = view;
        this.init();
        if (this._tag) {
            this._main.guideView.destroy();
            this._main.addTouchEvent();
        } else {
            this.start();
        }
    }

    start(): any {
        this._main.monkey.once('onStartShaking', this.onMonkeyStartShaking, this);
        this._main.boxListCtrl.boxs[0].once('onPassMiddle', this.onPassMiddle, this);
        this._main.boxListCtrl.updateSpeed(__boxMoveSpeed__ * 4);
    }

    onPassMiddle() {
        this._main.boxListCtrl.pause();
        this.addGuide();
        this._main.once(egret.TouchEvent.TOUCH_BEGIN, this.onTouch, this);
    }

    tips;
    async addGuide() {
        this._guideTop = new egret.Sprite();
        this._main.topLay.addChild(this._guideTop);
        const hand = await RES.getResAsync('guide_hand_png');
        const tips = await RES.getResAsync('guide_tips_png');
        const guide_dialog = await RES.getResAsync('guide_dialog_png');
        await this.showtipsAni(tips);
        await this.showhandAni(hand);
        await this.showguideAni(guide_dialog);
    }

    async showtipsAni(texture) {
        const pic = new egret.Bitmap(texture);
        pic.anchorOffsetX = pic.width >> 1;
        pic.anchorOffsetY = pic.height >> 1;
        this._guideTop.addChild(pic);
        return new Promise((r) => {
            egret.Tween.get(pic).set({ x: 0, y: 700 + 10 })
                .to({ x: 750 / 2 }, 200, egret.Ease.getBackOut(3))
                .call(() => r(pic));
        });
    }

    async showhandAni(texture) {
        const pic = new egret.Bitmap(texture);
        pic.anchorOffsetX = pic.width >> 1;
        pic.anchorOffsetY = pic.height >> 1;
        this._guideTop.addChild(pic);
        return new Promise((r) => {
            egret.Tween.get(pic).set({ x: 750, y: 700 + 230 }).to({ x: 750 / 2 }, 200, egret.Ease.getBackOut(3))
                .call(() => r(pic));
        });
    }

    async showguideAni(texture) {
        const pic = new egret.Bitmap(texture);
        pic.anchorOffsetX = pic.width >> 1;
        pic.anchorOffsetY = pic.height >> 1;
        this._guideTop.addChild(pic);
        return new Promise((r) => {
            egret.Tween.get(pic).set({ x: 750, y: 200 }).to({ x: 200 }, 200, egret.Ease.getBackOut(3))
                .call(() => r(pic));
        });
    }


    onTouch() {
        this._main.boxListCtrl.updateSpeed(__boxMoveSpeed__);
        this.setTag();
        this._main.guideView.destroy();
        egret.Tween.get(this._guideTop).to({ alpha: 0 }, 200).call(() => {
            this._main.topLay.removeChild(this._guideTop);
            this._guideTop = null;
        }, this);
        this._main.doAction();
        this._main.addTouchEvent();
    }

    onMonkeyStartShaking() {
        this._main.monkey.stop(Monkey.RANGE / 3)
    }

    private init() {
        this._tag = localStorage.getItem('guide') === '1';
    }

    setTag() {
        localStorage.setItem('guide', '1');
    }
}