import { IExposureData } from './../../common/IExposureData';
// import { GPool } from '../../../../tc/util/GPool';
import { LotteryData } from "../../common/lottery/LotteryData";
import { Data } from "../../Data";
import { GPool } from '../../../../tc/util/GPool';
/**
 *Created by cuiliqiang on 2018/3/8
 * 查询插件订单结果
 */

export class GetPlugOrderStatusData extends Data {
    /**
     * 订单状态    0：订单处理中    1：谢谢参与（有lottery）     2：中奖   -1：订单出错(当谢谢参与处理，没有lottery)
     */
    public result: number;

    /**
     * 推啊埋点数据
     */
    public exposure: IExposureData;

    /**
     * 奖品数据
     */
    public lottery: LotteryData;

    public update(result: any): void {
        if (!result) {
            return;
        }
        super.update(result);
        this.result = result.result;
        if (result.exposure) {
            this.exposure = result.exposure;
        } else if (this.exposure) {
            this.exposure = null;
        }
        if (result.lottery && result.lottery.type != 'thanks') {
            this.lottery = GPool.takeOut('LotteryData', LotteryData);
            if (!this.lottery) {
                this.lottery = new LotteryData();
            }
            this.lottery.update(result.lottery);
        } else {
            GPool.recover('LotteryData', this.lottery);
            this.lottery = null;
        }
    }
}
