import SheetAnimation from "../components/SheetAnimation";
export default class Net extends egret.Sprite {
    private _pic: SheetAnimation;
    constructor() {
        super();
        this._pic = new SheetAnimation();
        this.addChild(this._pic);
        this.createBg();
        this.y = 500;
    }

    doAction() {
        this._pic.play();
        this._pic.addEventListener('frameUpdate', this.onEnterFrame, this);
    }

    onEnterFrame(e: egret.Event) {
        if (e.data == this._pic.totalFrames) {
            this._pic.removeEventListener('frameUpdate', this.onEnterFrame, this);
            this._pic.stopAtFirstFrame();
        }
    }

    async createBg() {
        const sheet = await RES.getResAsync('net_json') as egret.SpriteSheet;
        this._pic.sheet = sheet;
        this._pic.fps = 10;
        this.alpha = 0;
        egret.Tween.get(this).to({ alpha: 1 }, 500);
        setInterval(()=>{
            this.doAction()
        },5000);
    }
}