/// 阅读 api.d.ts 查看文档
///<reference path="api.d.ts"/>

import * as path from 'path';
import { ExmlPlugin, IncrementCompilePlugin, TextureMergerPlugin, ConvertResConfigFilePlugin } from 'built-in';
import { MyExmlPlugin } from './MyExmlPlugin';
import { PublishExmlOnly } from './PublishExmlOnly';

const config: ResourceManagerConfig = {


    buildConfig: (params) => {

        const { target, command, projectName, version } = params;
        if (command == 'build') {
            const outputDir = '.';
            return {
                outputDir,
                commands: [
                    new ExmlPlugin('debug'), // 非 EUI 项目关闭此设置
                    new IncrementCompilePlugin(),
                ]
            }
        }
        else if (command == 'publish') {
            const outputDir = `bin-release/`;
            if (process.argv[3] == 'exml')
                return {
                    outputDir,
                    commands: [
                        new PublishExmlOnly('commonjs')
                    ]
                }
            return {
                outputDir,
                commands: [
                    new ExmlPlugin('commonjs'), // 非 EUI 项目关闭此设置
                    new TextureMergerPlugin({ textureMergerRoot: ['resource'] }),
                    new ConvertResConfigFilePlugin({
                        resourceConfigFiles: [{ filename: "resource/default.res.json", root: "resource/" }],
                        nameSelector: (p) => path.basename(p).split(".").join("_"),
                        TM_Verbose: true
                    }),
                    // new CustomPlugin()
                ]
            }
        }
        else {
            throw `unknown command : ${params.command}`
        }
    },

    mergeSelector: (path) => {
        if (path.indexOf("assets/bitmap/") >= 0) {
            return "assets/bitmap/sheet.sheet"
        }
        else if (path.indexOf("armature") >= 0 && path.indexOf(".json") >= 0) {
            return "assets/armature/1.zip";
        }
    },

    typeSelector: (path) => {
        const ext = path.substr(path.lastIndexOf(".") + 1);
        const typeMap = {
            "jpg": "image",
            "png": "image",
            "webp": "image",
            "json": "json",
            "fnt": "font",
            "pvr": "pvr",
            "mp3": "sound",
            "zip": "zip",
            "sheet": "sheet",
            "exml": "text"
        }
        let type = typeMap[ext];
        if (type == "json") {
            if (path.indexOf("sheet") >= 0) {
                type = "sheet";
            } else if (path.indexOf("movieclip") >= 0) {
                type = "movieclip";
            };
        }
        return type;
    }
}


export = config;
