import { addImage } from "./utils";
import Ball from "./Ball";
import World from "./World";
import { FACTOR } from "./consts";
import Brick from "./Brick";

export default class Gun extends egret.Sprite {
    _root: egret.DisplayObjectContainer;
    _world: World;
    _line: egret.Bitmap;
    _gun: egret.Bitmap;
    vec: egret.Point
    constructor(root: egret.DisplayObjectContainer, world: World) {
        super();
        this._root = root;
        this._world = world;
        this.initUI();
    }

    fire(vec: egret.Point) {
        egret.Tween.get(this._gun)
            .to({ scaleY: 0.6 }, 100)
            .to({ scaleY: 1 }, 100);
        const ball = this.addBall();
        ball.mass = 0;
        this._world.bodies.forEach(body => {
            if (body instanceof Brick) {
                this._world.setMaterial(ball, body);
            }
        })
        ball.applyImpulse([vec.x, vec.y], [0, 0]);
    }

    addBall() {
        const ball = new Ball();
        ball.position = [this.x / FACTOR, this.y / FACTOR];
        ball.skin.x = this.x;
        ball.skin.y = this.y;
        this._world.addBody(ball);
        this._world.skin.addChild(ball.skin);
        return ball;
    }

    enable() {
        this.hideLine();
        this.stage.once(egret.TouchEvent.TOUCH_BEGIN, this.onTouchBegin, this);
    }

    onTouchBegin() {
        this.showLine();
        this.stage.addEventListener(egret.TouchEvent.TOUCH_MOVE, this.onTouchMove, this);
        this.stage.once(egret.TouchEvent.TOUCH_END, this.onTouchEnd, this);
    }

    onTouchEnd(e: egret.TouchEvent): any {
        this.hideLine();
        this.stage.removeEventListener(egret.TouchEvent.TOUCH_MOVE, this.onTouchMove, this);

        const point = new egret.Point(e.stageX, e.stageY)
        var pos = new egret.Point(point.x - this.x, point.y - this.y);
        var angle: number = Math.atan2(pos.x, pos.y)
        var dis: number = 10000;
        var x: number = Math.ceil(Math.sin(angle) * dis);
        var y: number = Math.ceil(Math.cos(angle) * dis);
        const vec = new egret.Point(x, y);
        this.vec = vec;
        this.fire(vec);
    }

    onTouchMove(e: egret.TouchEvent) {
        const point = new egret.Point(e.stageX, e.stageY)
        var pos = new egret.Point(point.x - this.x, point.y - this.y);
        var r: number = -Math.atan2(pos.x, pos.y) * 180 / Math.PI;
        this._gun.rotation = r;
        this._line.rotation = r;
    }

    private initUI() {
        const line = addImage('line_png', this);
        line.anchorOffsetX = line.width / 2;
        const gun = addImage('gun_png', this);
        gun.anchorOffsetX = gun.width / 2;
        const numBg = addImage('numBg_png', this);
        numBg.anchorOffsetX = numBg.width >> 1;
        numBg.anchorOffsetY = numBg.height >> 1;
        this._line = line;
        this._gun = gun;
    }

    showLine() {
        this.addChildAt(this._line, 0);
    }

    hideLine() {
        this.removeChild(this._line)
    }
}