import { LADDER_H_NUMS } from "./gameconsts";
import { shuffle } from "./utils";

let counter;
export const resetCounter = () => {
    counter = 1;
}

export const getCounter = () => counter;

const getBlockShape = () => {
    const list = shuffle([1, 2, 3]);
    return list[0];
}

const random = (start: number, end: number) => {
    return start + (end - start) * Math.random();
}

const getNums = (currBallNums: number) => {
    return Math.ceil(currBallNums * random(1 * window['numsP'], 3.5 * window['numsP']));
}

const getNums2 = (currBallNums: number) => {
    return Math.ceil(currBallNums * random(4 * window['numsP'], 7 * window['numsP']));
}

const getSpecialNumBlocksNums = (currBallNums: number) => {
    if (currBallNums < 20) return 1;
    if (currBallNums < 50) return 2;
    return 3;
}

export const getBlocks = (currBallNums: number) => {
    const blockNums = Math.random() > 0.3 ? 3 : 2;
    let specialBall = 0;
    if (counter % 3 === 0) { // 每隔3行出现一个+球buff
        specialBall = 1;
    }

    let list = [];
    for (let i = 0; i < LADDER_H_NUMS; i++) {
        list.push(i);
    }
    list = shuffle(list);

    const blockPositions = list.slice(0, blockNums);
    const specialBallPosition = list[list.length - 1];
    const blocksInfo = [];
    for (let j = 0; j < blockPositions.length; j++) {
        const p = blockPositions[j];
        let nums = getNums(currBallNums);
        const specialNumBlocksNums = getSpecialNumBlocksNums(currBallNums);
        if (Math.random() < 0.3 && j < specialNumBlocksNums) {
            nums = getNums2(currBallNums);
        }
        blocksInfo.push({
            position: p,
            type: getBlockShape(),
            nums: nums
        });
    }
    counter++;
    return {
        blocksInfo: blocksInfo,
        specialBallPosition: specialBall ? specialBallPosition : -1
    };
}