import ComponentBase from "./ComponentBase";

export default class Loading extends ComponentBase {
    private static _parent: egret.Sprite;
    private static _instance: Loading;
    static get instace(): Loading {
        return Loading._instance || (Loading._instance = new Loading());
    }
    constructor() {
        super();
        this.horizontalCenter = 0;
        this.verticalCenter = 0;
        this.loadSkin();
    }

    show() {
        Loading._parent.addChild(this);
        if (this.skin && !this.hasEventListener(egret.Event.ENTER_FRAME))
            this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    hide() {
        Loading._parent.removeChild(this);
        if (this.hasEventListener(egret.Event.ENTER_FRAME))
            this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    static init(parent: egret.Sprite) {
        Loading._parent = parent;
    }

    onSkinComplete(): any {
        super.onSkinComplete();
        if (!this.hasEventListener(egret.Event.ENTER_FRAME))
            this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    onEnterFrame() {
        this.data.speed += 5;
    }

     get skinKey() { return 'Loading' }
}
