export class GMath {
    /**
     * 向下取整
     * @param n
     * @returns {number}
     */
    public static int(n: any): number {
        return n >> 0;
    }

    /**
     * 给数组随机排序
     * @param arr
     */
    public static randomArr(arr: any[]): any[] {
        const len = arr.length;
        for (let i = 0; i < len; i++) {
            const n = this.random(0, arr.length, true);
            const temp = arr[n];
            arr[n] = arr[i];
            arr[i] = temp;
        }
        return arr;
    }

    /**
     * 范围随机数
     * @param n1 范围起始
     * @param n2 范围结束
     * @param int 结果是否返回整数
     * @return {*}
     */
    public static random(n1: number, n2: number, int: boolean): number {
        let n: number;
        let min: number;
        let max: number;
        if ((typeof n1) != 'undefined' && (typeof n2) != 'undefined') {
            min = Math.min(n1, n2);
            max = Math.max(n1, n2);
            n = Math.random() * (max - min) + min;
        } else {
            n = Math.random();
        }
        if (int) {
            n = this.int(n);
        }
        return n;
    }
}