class Layers extends eui.UILayer {
    private _topLayer: egret.Sprite;
    private _popupLayer: egret.Sprite;
    private _sceneLayer: egret.Sprite;
    private _bottomLayer: egret.Sprite;
    init(root: eui.UILayer) {
        root.addChild(this);
        this._topLayer = new egret.Sprite();
        this._popupLayer = new egret.Sprite();
        this._sceneLayer = new egret.Sprite();
        this._bottomLayer = new egret.Sprite();
        this.addChild(this._bottomLayer);
        this.addChild(this._sceneLayer);
        this.addChild(this._popupLayer);
        this.addChild(this._topLayer);
    }

    _bg: egret.Bitmap;
    addFirstBackground(bitmap: egret.Bitmap): any {
        this._bg = bitmap;
        this._bottomLayer.addChild(bitmap);
    }

    removeFirstBackground(): any {
        this._bottomLayer.removeChild(this._bg);
        this._bg = null;
    }

    get topLayer() { return this._topLayer }
    get popupLayer() { return this._popupLayer }
    get sceneLayer() { return this._sceneLayer }

}

const layers = new Layers();
export default layers