import { getSkinPath } from "../../utils";
import { M_UpdateLand } from "./LandMgr";
import { M_HideOption } from "./Objs/OptionPanel";

export default class TimeProgressBar extends eui.Component {
    public bg: eui.Rect;
    public corpName: eui.Label;
    public progressBar: eui.Rect;
    public fillMask: eui.Rect;
    public progressFill: eui.Rect;
    public progressLabel: eui.Label;

    private labelText: string = '';
    private startTime: number;
    private nowTime: number;
    private endTime: number;

    private cTime: number;

    private progressText = '';
    private _timer: egret.Timer = null;

    private index;

    constructor(index, title, label, startTime, nowTime, endTime) {
        super();
        this.skinName = getSkinPath('Component/TimeProgressBar');

        this.labelText = title;
        this.startTime = startTime;
        this.nowTime = nowTime;
        this.endTime = endTime;
        this.progressText = 'hh时mm分后' + label;

        this.index = index;

        this.initUI();

        this.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            M_HideOption();
        }, this)
    }

    public addSpeed(callFun: Function) {
        this._timer.stop();
        this.nowTime -= 4 * 60 * 60;
        if(this.nowTime < 0){
            this.nowTime = 0;
        }
        let timer = this._convertTime(this.nowTime);
        let str = this.progressText;
        str = str.replace(/hh/g, timer.hour);
        str = str.replace(/mm/g, timer.min);
        str = str.replace(/ss/g, timer.sec);
        this.progressLabel.text = str;

        let progress = (this.nowTime - this.startTime) / (this.endTime - this.startTime);
        if(progress > 100) {
            progress = 100;
        }
        let _width = this.progressBar.width * progress;
        egret.Tween.get(this.progressFill)
            .to({width: _width}, 1000)
            .wait(600)
            .call(callFun);
    }

    private initUI() {
        this.progressFill.mask = this.fillMask;
        this.corpName.text = this.labelText;
        this.setProgress();

        this.cTime = this.nowTime + 4;
        this.cutFun();
        this._timer = new egret.Timer(1000, this.cTime);
        this._timer.addEventListener(egret.TimerEvent.TIMER, this.cutFun, this);
        this._timer.start();
    }

    private cutFun() {
        this.cTime -= 1;
        let timer = this._convertTime(this.cTime + 60);
        this.nowTime += 1;
        // console.log(this.cTime);
        if(this.cTime <= 0) {
            this.stop();
        }
        let str = this.progressText;
        str = str.replace(/hh/g, timer.hour);
        str = str.replace(/mm/g, timer.min);
        str = str.replace(/ss/g, timer.sec);
        this.progressLabel.text = str;
        this.setProgress();
    }

    public stop() {
        console.log('stop');
        this._timer && this._timer.stop();
        M_UpdateLand(this.index);
    }

    public destroy() {
        if(this._timer) {
            this._timer.stop();
            this._timer = null;
        }
    }

    /**
     * 设置进度
     */
    private setProgress() {
        let progress = (this.nowTime - this.startTime) / (this.endTime - this.startTime);
        if(progress > 100) {
            progress = 100;
        } else if(progress < 0) {
            progress = 0
        }
        this.progressFill.width = this.progressBar.width * progress;
    }

    /**
     * 通过时间戳获取几时积分几秒
     * @param time 时间戳（毫秒）
     * @private
     */
    private _convertTime(time: number): { hour, min, sec } {
        let hour = ~~(time / 3600);                              // 小时
        let min = ~~((time - hour * 3600) / 60);              // 分
        let sec = ~~((time - hour * 3600 - min * 60)); // 秒

        return {
            hour: this._prefixInteger(hour, 2),
            min: this._prefixInteger(min, 2),
            sec: this._prefixInteger(sec, 2)
        }
    }

    /**
     * 数字补0 例：(num = 2, length = 2) -> 02
     * @param num 数字
     * @param length 位数
     * @private
     */
    private _prefixInteger(num, length): string {
        return (Array(length).join('0') + num).slice(-length);
    }

}