import { NetManager } from './../../manager/NetManager';
import { DataManager } from './../../manager/DataManager';
import { GameModel } from '../common/GameModel';
import { GMath, GCache } from "duiba-tc";
import { IDynamicData } from '../..';
export class GamePlayModel extends GameModel {
    /**
     * 阶段提交次数
     */
    private datapashCount: number;

    /**
     * 阶段动态数据
     */
    private dynamics: IDynamicData[];

    /**
     * 游戏全程动态数据
     */
    private allDynamics: IDynamicData[][];

    public update(): void {
        this.dynamics = [];
        this.allDynamics = [];
        this.datapashCount = 0;
    }

    /**
     * 是否达到阶段提交的条件
     */
    public checkDatapash(score: number): boolean {
        const interfaceLimit = DataManager.ins.gameCfgData.defenseStrategy.interfaceLimit || 50;
        const scoreUnit = DataManager.ins.gameCfgData.defenseStrategy.scoreUnit;
        const nextDatapashScore: number = score - this.datapashCount * scoreUnit;
        if (nextDatapashScore >= scoreUnit && this.datapashCount < interfaceLimit) {
            return true;
        }
        return false;
    }

    /**
     * 阶段提交
     * @param net 
     */
    public datapash(): void {
        const dynamicStr: string = JSON.stringify(this.dynamics);
        this.allDynamics.push(this.dynamics);
        this.datapashData(null, dynamicStr);
        this.dynamics = [];
        this.datapashCount++;
    }

    /**
     * 添加防作弊数据
     * @param dynamic 
     */
    public addDynamic(dynamic: IDynamicData, ...args): void {
        this.dynamics.push(dynamic);
    }

    /**
     * 缓存最高分
     */
    public cacheMaxScore(score: number): void {
        //将最高纪录缓存
        let maxScore: number = GMath.int(GCache.readCache("maxScore"));
        if (!maxScore) {
            maxScore = 0;
        }
        maxScore = Math.max(maxScore, score);
        GCache.writeCache('maxScore', maxScore);
    }
    /**
     * 复活操作
     * @param callback
     * @param collectRuleId  集卡规则id
     * @param itemId  复活卡id 
     */
    public doRevive(callback: Function, collectRuleId:number, itemId:number): void {
        if(window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        NetManager.ins.doRevive((success: boolean) => {
            callback(success);
        },
        collectRuleId,
        itemId
        );
    }
    /**
     * 获得复活次数
     * @param callback
     * @param collectRuleId  集卡规则id
     * @param itemId  复活卡id 
     */
    public getReviveCardNum(callback:Function, collectRuleId:number, itemId:number): void {
        if(window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        NetManager.ins.getReviveCardNum((success: boolean) => {
            callback(success);
        },
        collectRuleId,
        itemId
        );
    }
    /**
     * 提交游戏成绩
     * @param callback 
     * @param score 得分
     * @param checkScore  是否校验得分
     * @param customizedType 定制类型 1推币机    
     */
    public submit(callback: Function, score: number, checkScore?: boolean, customizedType?: number): void {
        this.allDynamics.push(this.dynamics);
        this.gameSubmitData(callback, score, this.allDynamics, checkScore, customizedType);
        this.dynamics = [];
    }

    /**
     * 游戏结束弹窗
     */
    public get gameIsWinning(): boolean {
        return DataManager.ins.gameGetSubmitResultData.lottery ? true : false;
    }
}