import { GameModel } from '../common/GameModel';
import { DataManager } from '../../manager/DataManager';
import { TwLang } from '../../util/TwLang';
import { GFun } from "duiba-tc";
import { IGameOptionData } from '../..';
export class GameOptionModel extends GameModel {
    /**
     * 活动结束时间
     */
    public getEndTimeTxt(endTimeTxt: string = TwLang.lang_012, openPrizeTimeTxt: string = TwLang.lang_013): string {
        let str: string;
        str = GFun.replace(endTimeTxt, [DataManager.ins.gameCfgData.gameInfo.offDate]);
        if (DataManager.ins.gameCfgData.gameInfo.rankPrize) {
            str += "\n" + openPrizeTimeTxt;
        }
        return str;
    }

    /**
     * 奖品列表
     */
    public get optionList(): IGameOptionData[] {
        return DataManager.ins.getOptionsData.optionList;
    }
}