import { DataManager } from './../../manager/DataManager';
import { GFun } from "duiba-tc";
import { TwLang } from '../../util/TwLang';
import { GameModel } from '../common/GameModel';

export class GameEndModel extends GameModel {
    /**
     * 获取积分文案
     */
    public getScoreTxt(totalStr: string = TwLang.lang_011, maxStr: string = TwLang.lang_010): string {
        let str: string;
        if (DataManager.ins.gameCfgData.gameInfo.openTotalScoreSwitch) {
            str = GFun.replace(totalStr, [DataManager.ins.getInfoData.totalScore || '0']);
        } else {
            str = GFun.replace(maxStr, [DataManager.ins.getInfoData.maxScore || '0']);
        }
        return str;
    }
}