import { GPool } from "duiba-tc";
import { LotteryData } from "../../common/lottery/LotteryData";
import { Data } from "../../Data";
import { IExposureData } from "../../common/IExposureData";
/**
 *Created by cuiliqiang on 2018/3/12
 * 订单状态
 */

export class GetCustomOrderStatusData extends Data {
    /**
     * 推啊埋点数据
     */
    public exposure: IExposureData;

    /**
     * 奖品数据
     */
    public lottery: LotteryData;

    /**
     * 业务状态 -1处理失败 0处理中 1谢谢参与 2处理完成 3再来一次 101扣积分失败或者内部处理异常
     */
    public result: number;

    public update(data: any): void {
        if (!data) {
            return;
        }
        super.update(data);
        this.result = data.result;

        if (data.exposure) {
            this.exposure = data.exposure;
        } else if (this.exposure) {
            this.exposure = null;
        }

        if (data.lottery && data.lottery.type != 'thanks') {
            this.lottery = GPool.takeOut('LotteryData', LotteryData);
            if (!this.lottery) {
                this.lottery = new LotteryData();
            }
            this.lottery.update(data.lottery);
        } else {
            GPool.recover('LotteryData', this.lottery);
            this.lottery = null;
        }
    }
}
