import Scene from "../../views/Scene";
import { ModuleTypes } from "../../types/sceneTypes";
import { GDispatcher } from "../../../libs/tc/util/GDispatcher";
import SceneCtrl from "../../ctrls/sceneCtrl";
import Loading from "../../loading/Loading";

export default class LoadingScene extends Scene {
    public pBar: eui.ProgressBar;
    public pIconImg: eui.Image;
    public percentLb: eui.Label;
    public mainbg: eui.Image;
    private iconAct: egret.MovieClip;

    private lastVal: number;

    public get skinKey() {
        return 'LoadingScene'
    }

    public get groupName() {
        return 'loading_scene'
    }

    constructor(data?) {
        super(data);
        if(data) {

        }
        this.percentHeight = 100;

        this.lastVal = 0;
    }

    initEvents() {
        GDispatcher.addEvent('progress', this.setProgress, this);//626 117
    }

    removeEvents() {
        GDispatcher.removeEvent('progress', this.setProgress, this);
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();
        Loading.instace.show()
    }

    start(data?) {

    }

    protected onLoad(): void {
        this.initUI();
    }

    private initUI(): void {
        //初始化数据
        this.initData();

    }

    private initData(): void {
    }

    private setProgress(data): void {
        let v = data[0];
        // let time = 450;

        setTimeout(() => {
            if(v >= 100) {
                Loading.instace.hide();
                //this.goLastScene()
                SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE);
            }
        }, 500);
        this.lastVal = v;

        this.percentLb.text = v + '%';
    }

    protected async preLoadRes() {
        return new Promise(function(resolve, reject) {
            resolve();
        });
    }
}