"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var Home_1 = require("../Scenes/Home");
var Medal_1 = require("../Scenes/RoomScene/Medal");
var MedalsPanel = (function (_super) {
    __extends(MedalsPanel, _super);
    function MedalsPanel(data) {
        var _this = _super.call(this, data) || this;
        _this.medals = [];
        return _this;
    }
    Object.defineProperty(MedalsPanel.prototype, "skinKey", {
        get: function () {
            return 'MedalsPanel';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MedalsPanel.prototype, "groupName", {
        get: function () {
            return 'medals';
        },
        enumerable: true,
        configurable: true
    });
    MedalsPanel.prototype.onShowAnim = function () {
        // 位置：0.33s(屏幕外)-0.83s(下移1270px至于原位)；
        // 旋转：0.83s(顺时针5度)-1s(逆时针5度)-1.17s(顺时针2度)-1.33s(0度)；
        this.anchorOffsetX = 750 / 2;
        this.x = 750 / 2;
        egret.Tween.get(this)
            .set({ y: -870, rotation: 5 })
            .wait(330)
            .to({ y: 200 }, 500, egret.Ease.quartOut)
            .to({ rotation: -5 }, 170)
            .to({ rotation: 2 }, 170)
            .to({ rotation: 0 }, 160);
    };
    MedalsPanel.prototype.hideAnim = function () {
        var _y = 570 - (1624 - 750 / window.innerWidth * window.innerHeight) / 2;
        egret.Tween.get(this).wait(400).to({ alpha: 0 }, 100);
        return egret.Tween.get(this).to({ x: 510, y: _y, scaleX: 0.1, scaleY: 0.1 }, 500, egret.Ease.getPowOut(5));
    };
    MedalsPanel.prototype.start = function () {
        _super.prototype.start.call(this);
        this.initUI();
    };
    MedalsPanel.prototype.initUI = function () {
        var medals = Home_1.G_GetHomeDataByKey(Home_1.HOME.MEDALS);
        var index = 0;
        for (var k in medals) {
            var data = {
                key: k,
                index: index,
                name: medals[k].name,
                active: (medals[k].count > 0),
            };
            var newMedal = new Medal_1.default(data);
            this.sGroup.addChild(newMedal);
            this.medals.push(newMedal);
            index++;
        }
        this.tipsImg.visible = (index >= 4);
        this.wait1Group.x = ((this.medals.length) % 2 == 0) ? 55 : 249;
        this.wait1Group.y = 43 + ~~((this.medals.length) / 2) * 230;
        if (this.medals.length % 2 == 0) {
            this.wait2Group.visible = true;
            this.wait2Group.x = ((this.medals.length + 1) % 2 == 0) ? 55 : 249;
            this.wait2Group.y = 43 + ~~((this.medals.length + 1) / 2) * 230;
        }
    };
    MedalsPanel.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.medals.forEach(function (v) { return v.destroy(); });
    };
    return MedalsPanel;
}(Panel_1.default));
exports.default = MedalsPanel;
__reflect(MedalsPanel.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Panels/MedalsPanel\".MedalsPanel");
//# sourceMappingURL=MedalsPanel.js.map