import {NetManager} from "../../libs/tw/manager/NetManager";
import {MainIns} from "./MainScene/MainScene";

let HomeData = {
    gold: 0,    // 欢趣豆
    prop: {
        sp_food_1: 0,    // 饲料
        sp_food_2: 0,    // 水壶
        sp_prop_1: 0,    // 加速卡
    },
    product: {
        sp_1: 0,    // 鸡蛋
        sp_2: 0,    // 水稻
        sp_3: 0,    // 玉米
        sp_4: 0,    // 牛奶
        sp_5: 0,    // 土豆
        sp_6: 0,    // 核桃
    },
    seed: {
        sp_seed_1: 0,   // 鸡
        sp_seed_2: 0,   // 麦子
        sp_seed_3: 0,   // 玉米
        sp_seed_4: 0,   // 牛
        sp_seed_5: 0,   // 土豆
        sp_seed_6: 0,   // 核桃
    },
};

export enum HOME {
    GOLD = 'gold',
    PROP = 'prop',
    PRODUCT = 'product',
    SEED = 'seed',
}

/**
 * 刷新拥有的产物，使用数据之前要刷新，如打开仓库、打开商店
 */
export const G_UpdateHomeData = async function () {
    return new Promise((resolve) => {
        NetManager.ins.getProjectUserInfo((success, res) => {
            G_SetHomeDataByKey(HOME.GOLD, res.data.consumerCredits);
            NetManager.ins.queryUserSpList((success, res) => {
                if (!success) {
                    resolve();
                    return;
                }
                for (const k in HomeData.prop) {
                    HomeData.prop[k] = res.data[k] || 0;
                }
                for (const k in HomeData.product) {
                    HomeData.product[k] = res.data[k] || 0;
                }
                for (const k in HomeData.seed) {
                    HomeData.seed[k] = res.data[k] || 0;
                }
                if (MainIns()) {
                    MainIns().mainUI.setPropInfo();
                }
                resolve();
            });
        });
    })
};

export const G_GetHomeData = function () {
    return JSON.parse(JSON.stringify(HomeData));
};

export const G_GetHomeDataByKey = function (key: HOME) {
    return JSON.parse(JSON.stringify(HomeData[key]));
};

export const G_SetHomeDataByKey = function (key: HOME, val) {
    HomeData[key] = val;
};



