import { sqrt3 } from "../physics/Const";
import { RegTriangle } from "../physics/RegTriangle";
import PlayScene from "../PlayScene";

export default (that: PlayScene, x, y, length, rotation, key = 'specialRegTriangle') => {
    let block: RegTriangle;

    const sprite = new egret.Sprite();
    sprite.visible = window['debugPhysics'];
    sprite.alpha = 0.7;
    sprite.touchEnabled = sprite.touchChildren = false;
    //背景
    const shape = new egret.Shape();

    shape.graphics.beginFill(0xcccccc);
    shape.graphics.moveTo(0, -length * sqrt3 / 3);
    shape.graphics.lineTo(length / 2, length * sqrt3 / 6);
    shape.graphics.lineTo(-length / 2, length * sqrt3 / 6);
    shape.graphics.endFill();
    sprite["bg"] = shape;
    sprite.addChild(shape);
    //数字
    const txt = new egret.TextField();
    txt.width = length;
    txt.height = length;
    txt.anchorOffsetX = length / 2;
    txt.anchorOffsetY = length / 2;
    txt.size = 25;
    txt.textColor = 0xffffff;
    txt.textAlign = egret.HorizontalAlign.CENTER;
    txt.verticalAlign = egret.VerticalAlign.MIDDLE;
    sprite["txt"] = txt;
    sprite.addChild(txt);
    block = new RegTriangle(length, sprite);
    block.type = key;

    that.addChild(block.view)
    block.x = x;
    block.y = y;
    block.rotation = rotation;
    // block.num = num
    that.blocks.push(block);
}