import showLog from "../../new_tw/ctrls/showLog";
import { LotteryType } from "../../tw/enum/LotteryType";
import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import Panel from "./Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
export default class PrizePanel extends Panel {
    start(data) {
        super.start();
        const lottery = DataManager.ins.gameGetSubmitResultData.lottery;
        this.data = lottery;
        this.data.score = `本局分数 ${DataManager.ins.gameGetSubmitResultData.score}`;
        this.img.width = this.picBigWidth;
        this.img.height = this.picBigWidth / this.bigPicRatio;

        showLog(lottery);
        NetManager.ins.getInfo();
    }

    onTouchTap_closeBtn(): any {
        super.onTouchTap_closeBtn();
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }

    get picBigWidth() { return 510 };
    get bigPicRatio() { return 640 / 300 }

    initEvents() {
        super.initEvents();
        this.useBtn.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.img.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    onUse() {
        const lottery = DataManager.ins.gameGetSubmitResultData.lottery;
        if (lottery.type == LotteryType.COUPON || lottery.type == LotteryType.LUCKY) {
            window["downloadAppConfig"] =
                {
                    openUrl: lottery.openUrl,
                    iosDownloadUrl: lottery.iosDownloadUrl,
                    androidDownloadUrl: lottery.androidDownloadUrl,
                    confirm: lottery.confirm ? lottery.confirm : false
                };
            window["downloadApp"]();
            if (lottery.type == "lucky") {
                NetManager.ins.spmclick(DataManager.ins.gameGetSubmitResultData.exposure);
            }
        }
        else {
            window.location.href = lottery.link;
        }
    }

    img: eui.Image;
    useBtn: eui.Button;
     get skinKey() { return 'Prize' }

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn']]
    }
}