import { ModuleTypes } from "../types/sceneTypes";
import Panel from "../views/Panel";
export default class PanelCtrl {
    private _parent: egret.Sprite;
    private _mask: egret.Shape;

    static _instance: PanelCtrl;
    static get instance() {
        return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl())
    }

    init(parent: egret.Sprite) {
        this._parent = parent;
    }

    show(type: ModuleTypes, data?) {
        const cls = this._panelClassMap[type];
        const panel: Panel = new cls(data);
        this._current = panel;
        panel.start(data);
        this.add(panel);
    }

    private add(panel: Panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    }

    private remove(panel: Panel) {
        this._parent.removeChild(panel);
    }

    private onPanelHide(e: egret.Event) {
        const panel = e.target as Panel;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
    }

    private _panelClassMap: any;
    registerPanelClass(name, definition) {
        this._panelClassMap = this._panelClassMap || {};
        this._panelClassMap[name] = definition;
    }


    private _current: Panel;

    closeCurrent() {
        if (this._current)
            this.remove(this._current);
    }
}