import MainBase from "../libs/tl/MainBase";
import Msg from "./alert/Msg";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import RulePanel from "./rulePanel/RulePanel";
import StartScene from "./startScene/StartScene";
import { ModuleTypes } from "./types/sceneTypes";
import { NetManager } from "../libs/tw/manager/NetManager";

class Main extends MainBase {
    protected registerModules() {
        PanelCtrl.instance.registerPanelClass(ModuleTypes.MSG_PANEL, Msg);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.RULE_PANEL, RulePanel);
        SceneCtrl.instance.registerSceneClass(ModuleTypes.START_SCENE, StartScene);
    }

    protected getData() {
        super.getData();
        NetManager.ins.getInfo();
    }
    protected async createGameScene() {
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }
}

window['Main'] = Main;