export abstract class ABAudioManager {
    constructor() {

    }

    /**
     * 创建声音实例
     * @param {string} name 标识
     * @param {string} src 音频地址
     */
    public abstract createSound(name: string, src: string): void

    /**
     * 获取当前声音实例
     * @param {string} name 标识
     * @returns {any}
     * @constructor
     */
    public abstract getSound(name: string): any

    /**
     * 播放声音
     * @param {string} name 标识
     * @param {number} start 开始点 默认为0
     * @param {number} loop  循环次数 默认为1
     */
    public abstract play(name: string, start?: number, loop?: number): void

    /**
     * 暂停播放,或者恢复播放
     * @param {string} name 标识
     * @param {boolean} isPause 默认为true;是否要暂停，如果要暂停，则暂停；否则则播放
     */
    public abstract pause(name: string, isPause?: boolean): void

    /**
     * 停止声音播放
     * @param {string} name 标识
     * @param {.Sound} sound 声音实例
     */
    public abstract stop(name: string): void

    /**
     * 设置音量
     * @param {string} name 标识
     * @param {number} volume 音量大小，从0-1 在ios里 volume只能是0 或者1，其他无效
     */
    public abstract setVolume(name: string, volume: number): void

    /**
     * 设置所有音频音量
     * @param volume 
     */
    public abstract setAllVolume(volume: number): void

    /**
     * 暂停状态
     * @param name 
     */
    public abstract getPause(name: string): boolean

    /**
     * 从静态声音池中删除声音对象,如果一个声音再也不用了，建议先执行这个方法，再销毁
     * @param {string} name 声音实例
     */
    public abstract destory(name: string): void
}