import { ModuleTypes } from "../types/sceneTypes";
import getSkinPath from "../utils/getSkinPath";
export default class ComponentBase extends eui.Component {
    protected data: any;
    type:ModuleTypes
    constructor() {
        super();
        this.data = {};
    }

    loadSkin() {
        this.skinName = getSkinPath(this.skinKey);
        if (this.skin) {
            this.onSkinComplete();
        } else {
            this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        }
    }

    protected initEvents() { }

    protected removeEvents() { }

    start(data?) {

    }

    get skinKey():string { return null }

    protected onSkinComplete() {
        this.initEvents();
    }

    destroy() {
        this.removeEvents();
    }

}