import Loading from "../loading/Loading";
import ComponentBase from "../components/ComponentBase";

export default class Panel extends ComponentBase {
    constructor(data?) {
        super(data);
    }

    public onShowAnim() {
        egret.Tween.get(this)
            .set({visible: true, alpha: 0, y: -200})
            .to({alpha: 1, y: 0}, 500, egret.Ease.quartOut)
            .call(() => this.onShowAnimCall());
    }

    protected onShowAnimCall() {

    }

    public onHide() {
        return this.hideAnim().call(this.onHideAnimCall.bind(this));
    }

    protected hideAnim() {
        return egret.Tween.get(this)
            .to({y: 750 / window.innerWidth * window.innerHeight}, 300, egret.Ease.quartIn);
    }

    protected onHideAnimCall() {

    }

    protected getTapEvts(): any[] {
        return super.getTapEvts();
    }

    protected getBeginEvts(): any[] {
        return super.getBeginEvts();
    }

    initEvents() {
        super.initEvents();
        if(this.closeBtns && this.closeBtns.length > 0) {
            this.closeBtns.forEach((btn) => {
                    if(btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchClose, this)
                }
            )
        }
    }

    removeEvents() {
        super.removeEvents();
        if(this.closeBtns && this.closeBtns.length > 0) {
            this.closeBtns.forEach((btn) => {
                    if(btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchClose, this)
                }
            )
        }
    }

    protected onSkinComplete() {
        super.onSkinComplete();
        Loading.instace.hide();
    }

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn']]
    }

    onTouchClose(): any {
        this.hidePanel();
    }

    hidePanel() {
        this.destroy();
        this.dispatchEvent(new egret.Event('onDestroy'));
    }
}