import { ModuleTypes } from "../types/sceneTypes";
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from "./panelCtrl";

export default class SceneCtrl {
    // Static Method
    static _instance: SceneCtrl;
    static get instance() {
        return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl())
    }

    private _parent: eui.UILayer;
    private _currentScene: Scene;
    private _sceneClassMap: any;

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////// Public Method //////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    public init(parent: eui.UILayer) {
        this._parent = parent;
    }

    public change(type: ModuleTypes, data?) {
        if(this._currentScene) {
            this._currentScene.destroy();
            this._parent.removeChild(this._currentScene);
        }

        egret.Tween.removeAllTweens();
        PanelCtrl.instance.removeCurrent();

        Loading.instace.show();
        const cls = this._sceneClassMap[type];
        const scene: Scene = new cls(data);
        // scene.setSkinName();
        // scene.start();
        this.addToStage(scene);
    }

    public registerScenes(scenes) {
        scenes.forEach(v => this.registerSceneClass(v[0], v[1]));
    }


    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////// Private Method //////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    private registerSceneClass(name, definition) {
        this._sceneClassMap = this._sceneClassMap || {};
        this._sceneClassMap[name] = definition;
    }

    private addToStage(scene: Scene) {
        this._currentScene = scene;
        this._parent.addChild(scene);
    }
}