import TopLayerCtrl from "../ctrls/topLayerCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";

export const showToast = function(msg) {
    TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: msg});
};

export const btnDelay = function(targe: any, dtime: number = 500) {
    targe.touchEnabled = false;
    setTimeout(() => {
        targe.touchEnabled = true;
    }, dtime);
};

/**
 * 获取我的奖品链接
 */
export const gotoRecord = function(): string {
    let recordUrl: string;
    let oaId: number;
    if(DataManager.ins.customCfgData) {
        oaId = DataManager.ins.customCfgData.oaId;
        recordUrl = DataManager.ins.customCfgData.recordUrl;
    } else {
        oaId = DataManager.ins.gameCfgData.gameInfo.oaId;
        recordUrl = window['recordUrl'];
    }

    if(recordUrl.indexOf('?') != -1) {
        recordUrl += '&origins=' + oaId + '00';
    } else {
        recordUrl += '?origins=' + oaId + '00';
    }
    return recordUrl;
};

/**
 * 获取连接上的参数，以对象的形式返回
 */
export const getRequest = function() {
    const url = location.search;   //获取url中"?"符后的字串
    let theRequest = {};
    if(url.indexOf("?") != -1) {
        let str = url.substr(1);
        let strs = str.split("&");
        for(let i = 0; i < strs.length; i++) {
            theRequest[strs[i].split("=")[0]] = unescape(strs[i].split("=")[1]);
        }
    }
    return theRequest;
};

/**
 * 通过Key获取连接上的参数
 * @param key
 */
export const getRequestByKey = function(key: string) {
    return this.getRequest()[key];
};

/**
 * 时间戳转几时几分几秒
 * @param time 时间戳
 */
export const convertTime = function(time: number) {
    let hour = ~~(time / 3600000);                              // 小时
    let min = ~~((time - hour * 3600000) / 60000);              // 分
    let sec = ~~((time - hour * 3600000 - min * 60000) / 1000); // 秒

    return {
        hour: prefixInteger(hour, 2),
        min: prefixInteger(min, 2),
        sec: prefixInteger(sec, 2)
    }
};

/**
 * 数字补0
 * @param num 数字
 * @param length 位数
 */
export const prefixInteger = function(num, length) {
    return (Array(length).join('0') + num).slice(-length);
};

/**
 * 对象/数组 深拷贝
 * @param {Object} src - 来源对象
 * @param {Object} dst - 目标对象
 * @returns {Object} obj - 拷贝完成的对象
 */
export const deepClone = function(src, dst = undefined) {
    if(!(src instanceof Object) && !(src instanceof Array)){
        return src;
    }
    let _obj = dst || src instanceof Array ? [] : {};
    for(let key in src) {
        let prop = src[key];
        if(prop === _obj) { // 避免相互引用对象导致死循环，如src.a = dst的情况
            continue;
        }
        _obj[key] = ((typeof prop === 'object') ? deepClone(prop) : _obj[key] = prop);
    }
    return _obj;
};

/**
 * 产生一个固定范围的随机数(左闭右开)
 * @param start
 * @param end
 */
export const Random = function(start: number, end: number) {
    return Math.random() * (end - start) + start;
};

/**
 * 产生一个固定范围的随机整数(左闭右开)
 * @param start
 * @param end
 */
export const RandomInt = function(start: number, end: number) {
    return Math.floor(Math.random() * (end - start) + start);
};

/**
 * obj是否在array中
 * @param obj
 * @param array
 */
export const isInArray = function(obj: any, array: any[]) {
    for(let i in array) {
        if(obj == array[i]) {
            return true;
        }
    }
    return false;
};

/**
 * 简单的碰撞检测
 * @param obj1
 * @param obj2
 */
export const hitTest = function(obj1: any, obj2: any): boolean {
    let rect1: egret.Rectangle = obj1.getBounds();
    let rect2: egret.Rectangle = obj2.getBounds();
    rect1.x = obj1.x;
    rect1.y = obj1.y;
    rect2.x = obj2.x;
    rect2.y = obj2.y;
    return rect1.intersects(rect2);
};