import { ModuleTypes } from "../../types/sceneTypes";
import SceneCtrl from "../../ctrls/sceneCtrl";
import Scene from "../../views/Scene";
import { btnDelay } from "../../comm/UtilsConst";
import { DataManager } from "../../../libs/tw/manager/DataManager";
import { NetName } from "../../../libs/tw/enum/NetName";
import PanelCtrl from "../../ctrls/panelCtrl";
import { G_GetHomeDataByKey, HOME } from "../Home";
import Medal from "./Medal";

export default class RoomScene extends Scene {
    public group: eui.Group;
    public bg: eui.Image;
    public backBtn: eui.Image;
    public farm: eui.Image;
    public market: eui.Image;
    public medals: eui.Group;
    public ad: eui.Image;
    public nickname: eui.Label;

    private medalsArr: Medal[] = [];

    constructor(data?) {
        super(data);
    }

    protected start() {
        super.start();
        this.initUI();
        if(this.data && this.data.auto) {
            PanelCtrl.instance.show(ModuleTypes.MEDALS_PANEL);
        }
    }

    private initUI(): void {
        this.group.height = 750 / window.innerWidth * window.innerHeight;
        let userInfo = DataManager.ins.getData(NetName.Get_CONSUMERINFO).data;
        this.nickname.text = ((!userInfo || !userInfo.nickname || (userInfo.nickname == 'null'))
            ? '欢趣使者' : ((userInfo.nickname.length > 4) ? userInfo.nickname.slice(0, 3) + '...' : userInfo.nickname)) + '的小屋';

        let posArr = [
            [25, 68], [81, 68], [136, 68],
            [25, 132], [81, 132], [126, 132],
        ];

        let medal: {} = G_GetHomeDataByKey(HOME.MEDALS);
        let index = 0;
        for(let k in medal) {
            (medal[k].count >  0) ? function() {
                let newMedal = new Medal({key: k, active: true, index: index});
                newMedal.x = posArr[index][0];
                newMedal.y = posArr[index][1];
                newMedal.scaleX = newMedal.scaleY = 0.3;
                this.medals.addChild(newMedal);
                this.medalsArr.push(newMedal);
            }.bind(this)() : 0;
            index++;
        }
    }

    destroy() {
        super.destroy();
        this.medalsArr.forEach(v => v.destroy());
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts().concat([
            [this.backBtn, this.onTouchTap, this],
            [this.medals, this.onTouchTap, this],
            [this.ad, this.onTouchTap, this],
            [this.farm, this.onTouchTap, this],
            [this.market, this.onTouchTap, this],
        ]);
    }

    private onTouchTap(e: egret.TouchEvent) {
        btnDelay(e.target);
        switch(e.target) {
            case this.backBtn:
                SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE);
                break;

            case this.medals:   // 勋章墙
                PanelCtrl.instance.show(ModuleTypes.MEDALS_PANEL);
                break;

            case this.ad:   // 广告
                window.location.href = 'https://www.baidu.com/';
                console.log('广告');
                break;
            case this.farm: // 农场相框
                console.log('农场相框');
                break;
            case this.market:   // 集市
                window.location.href = 'https://www.baidu.com/';
                console.log('集市');
                break;
            default:
                break;
        }
    }


    public get skinKey() {
        return 'RoomScene'
    }

    public get groupName() {
        return 'room'
    }
}
