import { getSkinPath } from "../../utils";

export default class Medal extends eui.Component {
    public group: eui.Group;
    public img: eui.Image;
    public label: eui.Label;
    public light: eui.Image;
    public light_mask: eui.Image;

    private data = null;

    constructor(data?: { key: string, active: boolean, index: number, name?: string }) {
        super();
        this.skinName = getSkinPath('Objs/Medal');
        this.data = data || null;
        this.initUI();  // 设置显示
    }

    private initUI() {
        this.light.mask = this.light_mask;
        this.data.name ? this.label.text = this.data.name : this.label.visible = false;
        this.x = (this.data.index % 2 == 0) ? 55 : 249;
        this.y = 43 + ~~(this.data.index / 2) * 230;
        this.label.textColor = this.data.active ? 0xFFE595 : 0xbbbbbb;

        this.img.source = this.data.active ? `${this.data.key}_png` : 'sp_achv_0_png';
        this.light_mask.source = this.data.active ? `${this.data.key}_png` : 'sp_achv_0_png';
        (this.data.active) ? function() {
            setTimeout(() => {
                egret.Tween.get(this.light, {loop: true})
                    .set({x: -90})
                    .to({x: 100}, 1000)
                    .wait(1000);
            }, 1330 + 670 * this.data.index);
        }.bind(this)() : 0;
    }

    public destroy() {
        egret.Tween.removeTweens(this.light);
    }
}