import TimeProgressBar from "./TimeProgressBar";
import { MainIns } from "./MainScene";

export default class ProgressMgr {

    private progressBars = {};

    constructor() {

    }

    public addProgress(data) {
        /// TODO 根据数据添加进度条
        let {x, y, index, title, label, sTime, nTime, eTime} = data;
        let progressBar = new TimeProgressBar(index, title, label, sTime, nTime, eTime);
        progressBar.x = x;
        progressBar.y = y;
        MainIns().gameLayer.addChildAt(progressBar, 80);
        this.progressBars[index] = progressBar;

        return progressBar;
    }

    public removeProgress(index) {
        if(this.progressBars[index]) {
            this.progressBars[index].destroy();
            MainIns().gameLayer.removeChild(this.progressBars[index]);
            this.progressBars[index] = null;
            delete this.progressBars[index];
        }
    }

    public destroy() {
        for(let k in this.progressBars) {
            this.progressBars[k].destroy();
            this.removeProgress(k);
        }
        this.progressBars = {};
    }
}