import { getSkinPath } from "../../../utils";
import { MainDispatcher, MainIns, M_SetGameLayerUpdate } from "../MainScene";
import { NetManager } from "../../../../libs/tw/manager/NetManager";
import { btnDelay } from "../../../comm/UtilsConst";
import { M_Plant } from "../LandMgr";
import M_EVENT from "../MSceneEnum";
import { G_JudgeMedalPanel } from "../../Home";

// 触发Option隐藏
const M_HideOption = function() {
    MainDispatcher.dispatchEvent(M_EVENT.HIDE_OPTION);
};
// 显示Option
const M_ShowOption = function(data: { index: number, pos: { x: number, y: number } }) {
    MainDispatcher.dispatchEvent(M_EVENT.SHOW_OPTION, data);
};
export { M_HideOption, M_ShowOption };


/**
 * 操作面板
 */
export default class OptionPanel extends eui.Component {
    public chickBtn: eui.Image;
    public wheatBtn: eui.Image;
    public cattleBtn: eui.Image;
    public cornBtn: eui.Image;

    private data = null;

    ////////////////////// 单例 //////////////////////
    private static _instance: OptionPanel = null;

    public static getInstance(data?) {
        return OptionPanel._instance || (OptionPanel._instance = new OptionPanel(data))
    }

    public static destroy() {
        this._instance.removeEvents();
        this._instance = null;
    }

    ////////////////////// 单例 //////////////////////

    constructor(data?) {
        super();
        this.skinName = getSkinPath('Objs/OptionPanel');
        this.data = data || null;

        this.initEvents();
        this.initUI()
    }

    private initEvents() {
        [this.wheatBtn, this.chickBtn, this.cattleBtn, this.cornBtn].forEach((v) => {
            v.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        });
        MainDispatcher.addEvent(M_EVENT.SHOW_OPTION, this.showOption, this);
        MainDispatcher.addEvent(M_EVENT.HIDE_OPTION, this.hideOption, this);
    }

    private removeEvents() {
        [this.wheatBtn, this.chickBtn, this.cattleBtn, this.cornBtn].forEach((v) => {
            v.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        });
        MainDispatcher.removeEvent(M_EVENT.SHOW_OPTION, this.showOption, this);
        MainDispatcher.removeEvent(M_EVENT.HIDE_OPTION, this.hideOption, this);
    }

    private showOption(data?) {
        console.log(data);
        this.data = data;
        M_HideOption();   // 先触发隐藏，保证地块正常显示
        egret.Tween.removeTweens(this);
        // if(this.visible){
        //     return;
        // }

        this.touchEnabled = true;
        this.touchChildren = true;
        // this.x = data.pos.x + 190;
        // this.y = data.pos.y + 90 - (MainIns().gameLayer.height - MainIns().group.height) / 2;
        // egret.Tween.removeTweens(this);
        this.alpha = 1;
        if(this.visible) {
            return;
        }
        this.visible = true;
        egret.Tween.get(this).set({alpha: 0}).to({alpha: 1}, 170);
        // egret.Tween.get(this).set({scaleX: 0, scaleY: 0}).to({scaleX: 1, scaleY: 1}, 500, egret.Ease.backOut);
    }

    private hideOption() {
        if(!this.visible) {
            return;
        }
        this.touchEnabled = false;
        this.touchChildren = false;
        egret.Tween.removeTweens(this);
        egret.Tween.get(this).to({alpha: 0}, 170).call(() => {
            this.visible = false;
        });
        // egret.Tween.get(this).to({scaleX: 0, scaleY: 0}, 500, egret.Ease.quartInOut).call(() => {
        //     this.visible = false;
        // })
    }

    /// TODO 定义详细的操作
    private onTap(e: egret.TouchEvent) {
        const target = e.target;
        btnDelay(target);
        let petId;
        switch(target) {
            case this.chickBtn: // 鸡
                petId = 1;
                break;

            case this.wheatBtn: // 小麦
                petId = 2;
                break;

            case this.cornBtn:  // 玉米
                petId = 3;
                break;

            case this.cattleBtn: // 牛
                petId = 4;
                break;
            default:
                break;
        }
        // 0s（100%,100%）-0.1s(120%,120%)-0.2s(100%,100%)
        egret.Tween.get(target).to({scaleX: 1.2, scaleY: 1.2}, 100, egret.Ease.quadIn)
            .to({scaleX: 1, scaleY: 1}, 100, egret.Ease.quadOut).call(() => {
            M_HideOption();
            console.log(this.data.index, petId);
            M_SetGameLayerUpdate(false);
            NetManager.ins.doPlant((success) => {
                if(!success) {
                    M_SetGameLayerUpdate(true);
                    return;
                }
                M_Plant({landId: this.data.index, petId: petId});
                G_JudgeMedalPanel();
            }, this.data.index, petId);
        });
    }

    private initUI() {
        this.visible = false;
        this.x = 170 + 190;
        this.y = 669 + 50 - (MainIns().gameLayer.height - MainIns().group.height) / 2;
        this.anchorOffsetX = this.width / 2;
        this.anchorOffsetY = this.height;
    }
}