import { getSkinPath } from "../../../utils";
import Crop from "./Crop";
import { NetManager } from "../../../../libs/tw/manager/NetManager";
import { getlogItem } from "../../../comm/getlogItem";
import { M_ShowOption } from "./OptionPanel";

enum LAND_STATE {
    NONE = 'none',   // 无
    ACTIVE = 'active', // 点击
    PLANT = 'plant',  // 植物
    ANIMAL = 'animal'  // 动物
}

/**
 * 土地类
 */
export default class Land extends eui.Component {
    public land: eui.Image;
    public fence: eui.Image;
    public trough: eui.Image;

    private data = null;

    public index;

    public state: LAND_STATE;
    private crop: Crop;

    constructor(data?) {
        super();
        this.skinName = getSkinPath('Objs/Land');
        this.data = data || null;
        this.index = data.index;

        this.x = data.x;
        this.y = data.y;

        this.initEvents();  // 注册事件
        this.changeState(LAND_STATE.NONE);
        this.initUI();  // 设置显示
    }

    /**
     * 取消active状态
     */
    public reActive() {
        this.state == LAND_STATE.ACTIVE && this.changeState(LAND_STATE.NONE);
    }

    public plant(data) {
        this.crop.plant(data);
    }

    public updateData(data) {
        this.data = data;
        this.changeState(LAND_STATE.NONE);
        const landData = this.data.data;

        /// TODO 根据数据添加Crop 初始化状态
        if(landData.petId) {
            if(landData.petId == 1 || landData.petId == 4) {
                this.changeState(LAND_STATE.ANIMAL);
            } else {
                this.changeState(LAND_STATE.PLANT);
            }
        } else {
            this.changeState(LAND_STATE.NONE);
        }
        this.crop && this.crop.updateDate(this.data);
    }

    public destroy() {
        this.land.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        this.crop && this.crop.destroy();
        this.crop = null;
    }

    /**
     * 设置点击参数
     */
    private setTouchOption() {
        this.touchEnabled = false;  // 保证空白处不可点击，且子对象可点击
        this.touchChildren = true;
        this.land.touchEnabled = true;
        this.land.pixelHitTest = true;  // 保证透明像素不可点击
        this.fence.touchEnabled = false;    // 保证栅栏和食槽不可点击
        this.trough.touchEnabled = false;
    }

    private initEvents() {
        this.land.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    private onTap() {
        console.log(`点击了第${this.index}块土地, 当前状态是${this.state}`);
        if(this.state != LAND_STATE.NONE) {
            // M_HideOption();
            return;
        }
        // 显示Option
        NetManager.ins.clickLog(getlogItem(this.index + 7)); // 8, 9, 10, 11
        M_ShowOption({index: this.index, pos: {x: this.x, y: this.y}});
        this.changeState(LAND_STATE.ACTIVE);
    }

    private initUI() {
        NetManager.ins.showLog(getlogItem(this.index + 7)); // 8, 9, 10, 11
        this.setTouchOption();  // 设置点击参数
        const landData = this.data.data;

        /// TODO 根据数据添加Crop 初始化状态
        if(landData.petId) {
            if(landData.petId == 1 || landData.petId == 4) {
                this.changeState(LAND_STATE.ANIMAL);
            } else {
                this.changeState(LAND_STATE.PLANT);
            }
        } else {
            this.changeState(LAND_STATE.NONE);
        }
        this.crop = new Crop(this.data);
        this.addChildAt(this.crop, 2);
        this.crop.y = 75;
    }

    // 改变状态积
    private changeState(state: LAND_STATE) {
        if(state == this.state) {
            return;
        }

        this.state = state; // 设置状态

        this.land.source = `plant_land_${this.state}_png`;  // 设置图片
        this.fence.visible = (this.state == LAND_STATE.ANIMAL); // 显示栅栏
        this.trough.visible = (this.state == LAND_STATE.ANIMAL);    // 显示食槽

        /// TODO 定义状态积详情
        switch(this.state) {
            case LAND_STATE.NONE:   // 啥也没有

                break;
            case LAND_STATE.ACTIVE: // 点击

                break;
            case LAND_STATE.PLANT:  // 植物

                break;
            case LAND_STATE.ANIMAL: // 动物

                break;
            default:
                break;
        }
    }
}