import ComponentBase from "../../components/ComponentBase";
import { M_HideOption } from "./Objs/OptionPanel";
import PanelCtrl from "../../ctrls/panelCtrl";
import { ModuleTypes } from "../../types/sceneTypes";
import { btnDelay, showToast } from "../../comm/UtilsConst";
import { MainIns } from "./MainScene";
import { NetManager } from "../../../libs/tw/manager/NetManager";
import { DataManager } from "../../../libs/tw/manager/DataManager";
import { loadSvga } from "../../comm/loadSvga";
import { getSvga } from "../../utils";
import { getlogItem } from "../../comm/getlogItem";
import SceneCtrl from "../../ctrls/sceneCtrl";
import { G_GetHomeDataByKey, G_SetHomeDataByKey, G_UpdateHomeData, HOME } from "../Home";

export let propData = {
    sp_food_1: {name: 'food',},
    sp_food_2: {name: 'water',},
    sp_prop_1: {name: 'speed',},
};

export default class MainUI extends ComponentBase {
    public uiLayer: eui.Group;
    public propPanel: eui.Group;
    public speedGroup: eui.Group;
    public speedNum: eui.Label;
    public foodGroup: eui.Group;
    public foodNum: eui.Label;
    public waterGroup: eui.Group;
    public waterNum: eui.Label;
    public avatarPanel: eui.Group;
    public avatarImg: eui.Image;
    public avatarMask: eui.Image;
    public userName: eui.Label;
    public userGold: eui.Label;
    public medal: eui.Image;
    public warehouseBtn: eui.Button;
    public taskBtn: eui.Button;
    public houseBtn: eui.Group;
    public recordBtn: eui.Button;
    public shopBtn: eui.Button;

    constructor() {
        super();
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts().concat([
            [this, M_HideOption, this],
            [this.taskBtn, this.onTap, this],
            [this.warehouseBtn, this.onTap, this],
            [this.recordBtn, this.onTap, this],
            [this.shopBtn, this.onTap, this],
            [this.avatarImg, this.onTap, this],
            [this.houseBtn, this.onTap, this],
        ]).concat([ // OptionPanel
            [this.foodGroup, this.onTapOption, this],
            [this.waterGroup, this.onTapOption, this],
            [this.speedGroup, this.onTapOption, this],
        ])
    }

    private onTapOption(e: egret.TouchEvent) {
        btnDelay(e.target);
        switch(e.target) {
            case this.foodGroup:    // 食物数量区域
                NetManager.ins.clickLog(getlogItem(6));
                showToast('点击饿了的动物才能进行喂食哦');
                break;
            case this.waterGroup:   // 水壶数量区域
                NetManager.ins.clickLog(getlogItem(7));
                showToast('点击渴了的植物才能浇水哦');
                break;
            case this.speedGroup:
                NetManager.ins.clickLog(getlogItem(18));
                showToast('点击植物/动物去加速成长时间');
                break;
            default:
                break;
        }
    }

    /// TODO 定义详细操作
    private onTap(e: egret.TouchEvent) {
        btnDelay(e.target);
        switch(e.target) {
            case this.taskBtn:  // 任务按钮
                NetManager.ins.clickLog(getlogItem(3));
                PanelCtrl.instance.show(ModuleTypes.TASK_PANEL);
                break;

            case this.warehouseBtn: // 仓库按钮
                NetManager.ins.clickLog(getlogItem(4));
                G_UpdateHomeData().then(() => {
                    PanelCtrl.instance.show(ModuleTypes.WAREHOUSE_PANEL, G_GetHomeDataByKey(HOME.PRODUCT));
                });
                break;

            case this.avatarImg:    // 头像
                // window['share']();
                NetManager.ins.clickLog(getlogItem(1)); // 头像点击埋点
                break;

            case this.recordBtn:    // 兑换记录
                NetManager.ins.clickLog(getlogItem(2)); // 售卖记录点击
                window.location.href = window['record'];
                break;

            case this.shopBtn:  // 商店
                NetManager.ins.clickLog(getlogItem(5)); // 商店点击埋点
                G_UpdateHomeData().then(() => {
                    SceneCtrl.instance.change(ModuleTypes.SHOP_SCENE);
                });
                break;
            case this.houseBtn:
                SceneCtrl.instance.change(ModuleTypes.ROOM_SCENE);
                break;
            default:
                break;
        }
    }

    protected start() {
        super.start();
        this.initUI();
    }

    private initUI(): void {
        this.uiLayer.height = 750 / window.innerWidth * window.innerHeight;
        this.touchEnabled = true;

        this.warehouseBtn.anchorOffsetX = 53.5;
        this.warehouseBtn.anchorOffsetY = 60.5;

        this.houseBtn.y = (this.houseBtn.y - (MainIns().gameLayer.height - MainIns().group.height) / 2);

        this.avatarImg.mask = this.avatarMask;
        this.getUserInfo();
        this.getGoldNum();
        this.getPropInfo();

        // 埋点
        NetManager.ins.showLog(getlogItem(1));  // 头像曝光
        NetManager.ins.showLog(getlogItem(2));  // 兑换记录
        NetManager.ins.showLog(getlogItem(3));  // 任务按钮
        NetManager.ins.showLog(getlogItem(4));  // 仓库按钮
        NetManager.ins.showLog(getlogItem(5));  // 商店按钮
        NetManager.ins.showLog(getlogItem(6));  // 饲料区域
        NetManager.ins.showLog(getlogItem(7));  // 水区域
        NetManager.ins.showLog(getlogItem(18)); // 加速卡区域


        /// TODO 根据数据初始化头像Panel

        this.warehouseBtn.anchorOffsetX = 53.5;
        this.warehouseBtn.anchorOffsetY = 60.5;
    }

    public addGold() {
        loadSvga(getSvga('欢趣豆收取')).then(
            (mv: egret.MovieClip) => {
                mv.x = this.avatarPanel.x + 100;
                mv.y = this.avatarPanel.y;
                this.addChild(mv);
                mv.addEventListener(egret.Event.COMPLETE, () => {
                    mv.stop();
                    this.removeChild(mv);
                    this.getGoldNum();
                }, this);
            }
        );
    }

    public warehouseEffect() {
        // 0s(100%,100%)-0.1s(120%,80%)-0.2s(100%,100%)
        egret.Tween.removeTweens(this.warehouseBtn);
        egret.Tween.get(this.warehouseBtn)
            .to({scaleX: 1.2, scaleY: 0.8}, 100, egret.Ease.quadInOut)
            .to({scaleX: 1, scaleY: 1}, 100, egret.Ease.quadInOut);
    }

    public getPropInfo() {
        G_UpdateHomeData().then(() => {
            this.setPropInfo();
        });
    }

    public setPropInfo() {
        const data = G_GetHomeDataByKey(HOME.PROP);
        for(let k in propData) {
            this[`${propData[k].name}Num`].text = '× ' + data[k];
            DataManager.ins.updateData(propData[k].name, data[k]);
        }
        this[`${propData['sp_prop_1'].name}Group`].visible = (data['sp_prop_1'] > 0);
    }

    public getGoldNum() {
        NetManager.ins.getProjectUserInfo((success, res) => {
            if(!success) {
                return;
            }
            const data = res.data;
            this.userGold.text = `${data.unitName}：${data.consumerCredits}`;
            G_SetHomeDataByKey(HOME.GOLD, data.consumerCredits);
        });
    }

    private getUserInfo() {
        NetManager.ins.getConsumerInfo((success, res) => {
            if(!success) {
                this.userName.text = '欢趣使者';
                return;
            }
            const data = res.data;
            this.userName.text = (!data || !data.nickname || (data.nickname == 'null'))
                ? '欢趣使者' : ((data.nickname.length > 7) ? data.nickname.slice(0, 7) + '...' : data.nickname);
        });
    }

    destroy() {
        super.destroy();
    }

    get skinKey() {
        return 'MainUI';
    }

    public get groupName() {
        return 'main_ui';
    }
}