import Scene from "../../views/Scene";
import MainUI from "./MainUI";
import LandMgr from "./LandMgr";
import OptionPanel, { M_HideOption } from "./Objs/OptionPanel";
import Dispatcher from "../../comm/Dispatcher";
import ProgressMgr from "./ProgressMgr";

////////////////// Instance //////////////////
let instance: MainScene = null;
const MainIns = function(): MainScene {
    return instance;
};
const SetMainInstance = function(ins: MainScene) {
    instance = ins;
};
const DestroyMainInstance = function() {
    instance = null;
};

let canUpdate = true;
const M_SetGameLayerUpdate = function(enable: boolean) {
    instance.gameLayer.touchEnabled = enable;
    instance.gameLayer.touchChildren = enable;
    canUpdate = enable;
};

const M_CanUpdate = function() {
    return canUpdate;
};

export { MainIns, M_SetGameLayerUpdate, M_CanUpdate };
////////////////// Instance //////////////////

// Index场景的事件收发器
let MainDispatcher: Dispatcher = null;
export { MainDispatcher };

const NewMainDispatcher = function() {
    MainDispatcher = new Dispatcher()
};
const DestroyMainDispatcher = function() {
    MainDispatcher = null;
};

/**
 * 主场景
 * Tips：
 *   1.在本场景中因为需求坑爹（需要上下居中适配并加固定导航栏），所以进行手动适配
 *   2.在MainScene中：
 *       group 为适配层，该层 height = 实际画布高度
 *       gameLayer 为游戏层，该层在 group 中上下居中
 *       获得高度差可用 gameLayer.height - group.height
 *       需要将非 gameLayer 层中对象准确定位可将定位高度减去 上面的值/2 -> (1624 - 750 / window.innerWidth * window.innerHeight) / 2
 *   3.使用上面的 MainIns() 可取得IndexScene的场景单例，该单例在MainScene场景销毁时会自动销毁，MainScene场景生成时自动赋值
 *   4.使用上面的 MainDispatcher 可取得独立在MainScene的场景中的事件收发器单例，该单例在MainScene场景销毁时会自动销毁，MainScene场景生成时自动赋值
 */
export default class MainScene extends Scene {
    public group: eui.Group;
    public bg: eui.Image;
    public gameLayer: eui.Group;

    public mainUI: MainUI;
    public optionPanel: OptionPanel;
    public progressMgr: ProgressMgr;

    constructor(data?) {
        super(data);
    }

    public landMgr: LandMgr = null;

    protected start() {
        super.start();
        SetMainInstance(this); // 设置单例
        NewMainDispatcher();   // 创建一个局部事件收发器
        M_SetGameLayerUpdate(true);
        this.initUI();
    }

    private initUI(): void {
        this.group.height = 750 / window.innerWidth * window.innerHeight;

        // 创建UI层
        this.mainUI = new MainUI();
        this.addChild(this.mainUI);

        this.gameLayer.touchThrough = true; // 点击穿透。。防止设计touchEnable后无法点击bg

        // 创建进度条管理器
        this.progressMgr = new ProgressMgr();

        // 创建土地管理器
        this.gameLayer.touchEnabled = false;
        this.landMgr = new LandMgr(this);

        // 创建操作Panel（初始为隐藏状态）
        this.optionPanel = OptionPanel.getInstance();
        this.addChild(this.optionPanel);
    }

    destroy() {
        super.destroy();
        /// TODO 可能的需要清除的东西
        M_SetGameLayerUpdate(false);
        OptionPanel.destroy();
        this.mainUI.destroy();
        this.progressMgr.destroy();
        this.landMgr.destroy();
        DestroyMainDispatcher();    // 删除局部收发器
        DestroyMainInstance(); // 清除单例
        egret.Tween.removeAllTweens();
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts().concat([
            [this.bg, this.onTouchTap, this],   // 点到bg触发Option隐藏，因为在游戏层中其他游戏元素都在bg上层
        ]);
    }

    private onTouchTap(e: egret.TouchEvent) {
        switch(e.target) {
            case this.bg:
                M_HideOption();
                break;
            default:
                break;
        }
    }

    protected async preLoadRes() {

    }

    public get skinKey() {
        return 'MainScene'
    }

    public get groupName() {
        return 'main_scene'
    }

}