import Land from "./Objs/Land";
import { MainDispatcher, MainIns } from "./MainScene";
import { NetManager } from "../../../libs/tw/manager/NetManager";
import { GDispatcher } from "../../../libs/tc/util/GDispatcher";
import { loadSvga } from "../../comm/loadSvga";
import { getSvga } from "../../utils";
import M_EVENT from "./MSceneEnum";
import { M_HideOption } from "./Objs/OptionPanel";

/**
 * 示意图
 *    ////////////
 *   /////1 1////    ////////////
 *  /////1 1////    /////2 2////
 * ////////////    /////2 2////
 *                ////////////
 *    ////////////
 *   /////3 3////    ////////////
 *  /////3 3////    /////4 4////
 * ////////////    /////4 4////
 *                ////////////
 */

const landPos = [   // 地块位置（注意顺序，影响层级）
    {x: 170, y: 669},
    {x: 396, y: 778},
    {x: 43, y: 851},
    {x: 288, y: 972},
];

export default class LandMgr {
    private _parent: egret.DisplayObject = null;
    public get parent() {
        return this._parent;
    }

    public lands: Land[] = [];

    constructor(parent: egret.DisplayObject) {
        this._parent = parent;

        this.initEvents();
        this.getLandInfo();
    }

    private initEvents() {
        MainDispatcher.addEvent(M_EVENT.HIDE_OPTION, this.reActiveAll, this);
        GDispatcher.addEvent('docVisible', this.updateLandInfo, this);
        MainDispatcher.addEvent(M_EVENT.UPDATE_LANDS, this.updateLandInfo, this);
        MainDispatcher.addEvent(M_EVENT.PLANT, this.plant, this);
    }

    public destroy() {
        for(let i = 0; i < this.lands.length; i++) {
            this.lands[i].destroy();
            this.lands[i] = null;
        }
        MainDispatcher.removeEvent(M_EVENT.HIDE_OPTION, this.reActiveAll, this);
        GDispatcher.removeEvent('docVisible', this.updateLandInfo, this);
        MainDispatcher.removeEvent(M_EVENT.UPDATE_LANDS, this.updateLandInfo, this);
        MainDispatcher.removeEvent(M_EVENT.PLANT, this.plant, this);
    }

    private plant(data) {
        this.lands[data.landId - 1].plant(data);
    }


    private reActiveAll() {
        this.lands.forEach(v => v.reActive());
    }

    /**
     * 添加地块
     */
    private addLand(data) {
        for(let v of data) {
            let newLand = new Land({data: v, index: v.id, x: landPos[v.id - 1].x, y: landPos[v.id - 1].y});
            MainIns().gameLayer.addChildAt(newLand, v.id);
            this.lands.push(newLand);   // 加入数组方便管理
        }
        loadSvga(getSvga('流水动效')).then(
            (mv: egret.MovieClip) => {
                mv.x = 550;
                mv.y = 865;
                mv.touchEnabled = false;
                MainIns().gameLayer.addChildAt(mv, 3);
            }
        )
    }

    private getLandInfo() {
        NetManager.ins.getLandInfo((success, res) => {
            if(!success) {
                return;
            }
            this.addLand(res.data);
        });
    }

    private updateLandInfo() {
        console.log('Update Lands');
        NetManager.ins.getLandInfo((success, res) => {
            M_HideOption();
            if(!success) {
                return;
            }
            for(let i = 0; i < res.data.length; i++) {
                let v = res.data[i];
                this.lands[i].updateData({data: v, index: v.id, x: landPos[v.id - 1].x, y: landPos[v.id - 1].y});
            }
        });
    }
}

const M_UpdateLand = function() {
    MainDispatcher.dispatchEvent(M_EVENT.UPDATE_LANDS);
};

const M_Plant = function(data: { landId: number, petId: number }) {
    MainDispatcher.dispatchEvent(M_EVENT.PLANT, data);
};

export { M_UpdateLand, M_Plant }
