import Panel from "../views/Panel";
import TopLayerCtrl from "../ctrls/topLayerCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { btnDelay, showToast } from "../comm/UtilsConst";
import { MainDispatcher } from "../Scenes/MainScene/MainScene";
import { getlogItem } from "../comm/getlogItem";
import { G_GetHomeDataByKey, G_UpdateHomeData, HOME } from "../Scenes/Home";
import SceneCtrl from "../ctrls/sceneCtrl";

export let productData = {
    'sp_1': {   // 鸡蛋
        key: 'sp_1',
        name: 'egg',
        nameLabel: '鸡蛋',
        numLabel: '个',
        titleImg: 'sellTitle_egg_png',
        price: 0,
    },
    'sp_2': {   // 麦粉
        key: 'sp_2',
        name: 'wheat',
        nameLabel: '麦粉',
        numLabel: '袋',
        titleImg: 'sellTitle_wheat_png',
        price: 0,
    },
    'sp_3': {   // 玉米
        key: 'sp_3',
        name: 'corn',
        nameLabel: '玉米',
        numLabel: '个',
        titleImg: 'sellTitle_corn_png',
        price: 0,
    },
    'sp_4': {   // 牛奶
        key: 'sp_4',
        name: 'milk',
        nameLabel: '牛奶',
        numLabel: '瓶',
        titleImg: 'sellTitle_milk_png',
        price: 0,
    }
};

const posArr = [
    [0, 0],
    [354, 0],
    [0, 359],
    [354, 359],
];

export default class WareHousePanel extends Panel {
    public closeBtn: eui.Image;
    public record_btn: eui.Image;
    public noneImg: eui.Image;
    public crops: eui.Scroller;

    public get skinKey() {
        return 'WareHouse'
    }

    public get groupName() {
        return 'warehouse'
    }

    constructor(data?) {
        super(data);

    }

    onShowAnim() {
        const canvasH = 750 / window.innerWidth * window.innerHeight;
        egret.Tween.get(this).set({y: canvasH}).to({y: canvasH - 715}, 300, egret.Ease.quadInOut);
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts().concat([
            [this.record_btn, this.onTap, this],
        ])
    }

    private onTap(e: egret.TouchEvent) {
        switch(e.target) {
            case this.record_btn:   // 售卖记录
                btnDelay(this.record_btn);
                TopLayerCtrl.instance.show(ModuleTypes.SELL_RECORD, {}, .3);
                break;

            default:
                break
        }
    }

    protected start() {
        super.start();
        NetManager.ins.priceInfo((success, res) => {
            if(!success) {
                return;
            }
            const data = res.data;
            for(let k in productData) {
                productData[k].price = data[k];
            }
        });
        this.initUI();
    }

    private initUI(): void {
        this.setUI(this.data);
        MainDispatcher.addEvent('updateWareHouse', this.getWareHouseInfo, this);
        MainDispatcher.addEvent('closeWareHouse', this.onTouchClose, this);
    }

    onTouchClose(): any {
        return super.onTouchClose();
    }

    destroy() {
        super.destroy();
        MainDispatcher.removeEvent('updateWareHouse', this.getWareHouseInfo, this);
        MainDispatcher.removeEvent('closeWareHouse', this.onTouchClose, this);
    }

    /**
     * 仓库排列
     * @param res
     */
    private setUI(res) {

        const data = this.data;

        let showKey = [];
        for(let k in productData) {
            if(data[k] <= 0) {
                this[`${productData[k].name}_group`].visible = false;
            } else {
                showKey.push(k);
                this[`${productData[k].name}_label`].text = `数量：${data[k]}`;
                this[`${productData[k].name}_sell_btn`].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                    NetManager.ins.clickLog(getlogItem(16));
                    btnDelay(this[`${productData[k].name}_sell_btn`]);
                    TopLayerCtrl.instance.show(ModuleTypes.SELL_PANEL, {key: k, total: data[k]}, .4);
                });
                this[`${productData[k].name}_ex_btn`].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                    NetManager.ins.clickLog(getlogItem(17));
                    btnDelay(this[`${productData[k].name}_ex_btn`]);
                    // showToast('欢趣商店待开放，过段日子再来吧~');
                    SceneCtrl.instance.change(ModuleTypes.SHOP_SCENE);
                });
            }
        }

        for(let i = 0; i < showKey.length; i++) {
            this[`${productData[showKey[i]].name}_group`].x = posArr[i][0];
            this[`${productData[showKey[i]].name}_group`].y = posArr[i][1];
        }
        this.crops.visible = (showKey.length > 0);
        this.noneImg.visible = !(showKey.length > 0);
    }

    private getWareHouseInfo() {
        G_UpdateHomeData().then(() => {
            this.setUI(G_GetHomeDataByKey(HOME.PRODUCT));
        })
    }
}
