import Panel from "../views/Panel";

export default class TaskToast extends Panel {
    public title: eui.Label;
    public foodGroup: eui.Group;
    public foodLabel: eui.Label;
    public waterGroup: eui.Group;
    public waterLabel: eui.Label;

    public get skinKey() {
        return 'TaskToast'
    }

    constructor(data) {
        super(data);
        // this.data = data;
    }

    onShowAnim() {

    }

    initEvents() {
        super.initEvents();
        // this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_this, this);

    }

    removeEvents() {
        super.removeEvents();
        // this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_this, this);
    }

    protected start() {
        super.start();
        this.title.text = this.data.title;
        this.foodLabel.text = "×" + this.data.food;
        this.waterLabel.text = "×" + this.data.water;

        if(this.data.food <= 0) {
            this.foodGroup.visible = false;
            this.waterGroup.x = 162;
        }

        if(this.data.water <= 0) {
            this.waterGroup.visible = false;
            this.foodGroup.x = 162;
        }

        const canvasW = 750 / window.innerWidth * window.innerWidth;
        const canvasH = 750 / window.innerWidth * window.innerHeight;
        this.anchorOffsetX = this.width / 2;
        this.anchorOffsetY = this.height / 2;
        this.x = canvasW / 2;
        this.y = canvasH / 2;
        egret.Tween.removeTweens(this);
        egret.Tween.get(this)
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1, scaleY: 1}, 330, egret.Ease.backOut)
            .wait(1200)
            .to({alpha: 0}, 500, egret.Ease.quadInOut)
            .call(this.onTouchClose.bind(this));
    }
}