import Panel from "../views/Panel";
import { getSkinPath } from "../utils";
import TopLayerCtrl from "../ctrls/topLayerCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { MainDispatcher, MainIns } from "../Scenes/MainScene/MainScene";
import { getlogItem } from "../comm/getlogItem";

let taskUi = {
    1: {
        icon: '签到 icon_png',
        btnLabel: '去签到',
        label: '每日签到'
    },
    2: {
        icon: '分享 icon_png',
        btnLabel: '去分享',
        label: '分享给好友'
    },
    3: {
        icon: '消费 icon_png',
        btnLabel: '去完成',
        label: '访问欢趣派对',
        link: 'https://gonghang.activity-1.m.duiba.com.cn/projectx/p0f8b79c7/index.html'
    },
    4: {
        icon: '生活日 icon_png',
        btnLabel: '去完成',
        label: '访问欢趣市集',
        link: 'https://gonghang.activity-1.m.duiba.com.cn/hdtool/index?id=3737984&dbnewopen'
    },
};

export default class TaskPanel extends Panel {
    public list: eui.List;

    private isShow = false;

    public get skinKey() {
        return 'TaskPanel'
    }

    public get groupName() {
        return 'task_panel'
    }

    constructor(data?) {
        super(data);

    }

    onShowAnim() {
        const canvasH = 750 / window.innerWidth * window.innerHeight;
        egret.Tween.get(this).set({y: canvasH}).to({y: canvasH - 1010}, 300, egret.Ease.quadInOut);
    }

    protected start() {
        super.start();

        this.initUI();
    }

    private initUI(): void {
        MainDispatcher.addEvent('getTaskInfo', this.getTaskInfo, this);
        this.getTaskInfo();
    }

    destroy() {
        MainDispatcher.removeEvent('getTaskInfo', this.getTaskInfo, this);
        super.destroy();
    }

    private getTaskInfo() {
        NetManager.ins.getTaskInfo((success, res) => {
            if(!success) {
                return;
            }
            let data = res.data;
            if(!this.isShow) {
                this.isShow = true;
                data.forEach((v) => {
                    (v.status == 0) ? NetManager.ins.showLog(getlogItem(v.id + 11)) : 0;   // 12, 13, 14, 15
                });
            }
            this.list.useVirtualLayout = false;
            this.list.itemRenderer = TaskItem;
            this.list.dataProvider = new eui.ArrayCollection(data);
        });
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////
/**
 * 任务中心列表
 */
class TaskItem extends eui.ItemRenderer {
    public icon: eui.Image;
    public title: eui.Label;
    public textKHD: eui.Label;
    public prizeGroup: eui.Group;
    public foodGroup: eui.Group;
    public textFood: eui.Label;
    public waterGroup: eui.Group;
    public textWater: eui.Label;
    public btn: eui.Group;
    public btn_bg: eui.Image;
    public btn_label: eui.Label;

    constructor() {
        super();
        this.skinName = getSkinPath('TaskItem');
    }

    dataChanged() {
        this.icon.source = taskUi[this.data.id].icon;
        this.title.text = taskUi[this.data.id].label;

        this.textFood.text = '×' + this.data.spFood1RewardNum;
        this.textWater.text = '×' + this.data.spFood2RewardNum;

        /// TODO 0奖励隐藏的临时低效方案，待优化
        if(this.data.spFood1RewardNum <= 0) {
            this.foodGroup.visible = false;
            this.waterGroup.x = this.foodGroup.x;
        }
        if(this.data.spFood2RewardNum <= 0) {
            this.waterGroup.visible = false;
        }
        this.setBtn();
    }

    private setBtn() {
        this.btn_label.text = (this.data.status == 0) ? taskUi[this.data.id].btnLabel : '已领取';
        this.btn_label.textColor = (this.data.status == 0) ? 0xffffff : 0x9a9a9a;
        this.btn_bg.visible = (this.data.status == 0);

        let _f = () => {
            TopLayerCtrl.instance.show(ModuleTypes.TASK_TOAST, {
                title: (this.data.id == 1) ? '签到成功' : '分享成功',
                food: this.data.spFood1RewardNum,
                water: this.data.spFood2RewardNum,
            });
            MainDispatcher.dispatchEvent('getTaskInfo');
            MainIns().mainUI.getPropInfo();
        };

        if(this.data.status == 0) {
            this.btn.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                this.btn.touchEnabled = false;
                NetManager.ins.clickLog(getlogItem(this.data.id + 11));   // 12, 13, 14, 15
                NetManager.ins.doTask((success, res) => {
                    this.touchEnabled = true;
                    if(!success) {
                        return;
                    }

                    if(this.data.id == 1 || this.data.id == 2) {
                        (this.data.id == 2) ? (
                            window['share'](),
                                setTimeout(_f, 3000)) : _f();
                    } else {
                        MainDispatcher.dispatchEvent('getTaskInfo');
                        MainIns().mainUI.getPropInfo();
                        window.location.href = taskUi[this.data.id].link;
                    }
                }, this.data.id);
            }, this);
        }
    }
}
